/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ISoulConsumption;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class ItemGraveKey
extends Item
implements ISoulConsumption {
    private static final String name = "grave_key";

    public ItemGraveKey() {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(null);
        this.func_77625_d(1);
    }

    public static boolean setTombPos(ItemStack stack, BlockPos tombPos, int tombDim) {
        if (!ItemGraveKey.isStackValid(stack)) {
            return false;
        }
        NBTStackHelper.setBlockPos(stack, "tombPos", tombPos);
        NBTStackHelper.setInteger(stack, "tombDim", tombDim);
        return true;
    }

    public static BlockPos getTombPos(ItemStack stack) {
        if (!ItemGraveKey.isStackValid(stack)) {
            return BlockPos.field_177992_a;
        }
        return NBTStackHelper.getBlockPos(stack, "tombPos");
    }

    public static int getTombDim(ItemStack stack) {
        if (!ItemGraveKey.isStackValid(stack)) {
            return Integer.MAX_VALUE;
        }
        return NBTStackHelper.getInteger(stack, "tombDim");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!ItemGraveKey.isStackValid(stack)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int tombDimId = ItemGraveKey.getTombDim(stack);
        if (tombDimId != world.field_73011_w.func_177502_q()) {
            return;
        }
        BlockPos tombPos = ItemGraveKey.getTombPos(stack);
        if (!world.func_175667_e(tombPos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(tombPos);
        if (tile == null || !(tile instanceof TileEntityTombstone)) {
            player.func_174820_d(slotId, null);
            player.field_71069_bz.func_75142_b();
        }
    }

    protected static boolean isStackValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemGraveKey;
    }

    public String func_77653_i(ItemStack stack) {
        return this.func_77636_d(stack) ? Helper.getTranslation("item.grave_key.nameUpgraded") : StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (this.isEnchanted(stack)) {
            player.func_71064_a((StatBase)AchievementHandler.getAchievement("upgrade_grave_key"), 1);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return ItemGraveKey.isStackValid(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!ItemGraveKey.isStackValid(stack) || !ConfigurationHandler.upgradeTombKey) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (ItemGraveKey.isStackValid(stack) && stack.func_77942_o()) {
            int tombDimId = ItemGraveKey.getTombDim(stack);
            BlockPos tombPos = ItemGraveKey.getTombPos(stack);
            if (tombDimId != Integer.MAX_VALUE && tombPos != BlockPos.field_177992_a) {
                String tombDim = tombDimId == 0 ? "The Overworld" : (tombDimId == -1 ? "The Nether" : (tombDimId == -1 ? "The End" : "Unknown Land " + tombDimId));
                list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.dimTitle") + " : " + tombDim);
                list.add(EnumChatFormatting.WHITE + Helper.getTranslation("item.info.posTitle") + " :  " + tombPos.func_177958_n() + ", " + tombPos.func_177956_o() + ", " + tombPos.func_177952_p());
            }
            if (this.func_77636_d(stack)) {
                list.add(EnumChatFormatting.AQUA + Helper.getTranslation("item.info.tele"));
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.isEnchanted(stack)) {
            BlockPos pos = ItemGraveKey.getTombPos(stack);
            int dimId = ItemGraveKey.getTombDim(stack);
            if (player.field_71093_bK != dimId && !ConfigurationHandler.teleportDim) {
                Helper.sendMessage("message.teleport_near_grave.sameDimension", player, true);
            } else {
                stack.func_77978_p().func_74757_a("enchant", false);
                TeleportUtils.TeleportLocation location = new TeleportUtils.TeleportLocation((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.5, dimId);
                location.sendEntityToCoords((Entity)player);
                SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                Main.proxy.useMagic(world, player.func_180425_c());
                Helper.sendMessage("message.teleport_near_grave.success", player, true);
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        if (!ConfigurationHandler.highlight) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!ItemGraveKey.isStackValid(player.func_70694_bm())) {
            return;
        }
        if (ItemGraveKey.getTombDim(player.func_70694_bm()) != player.field_71093_bK) {
            return;
        }
        double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialTicks;
        double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialTicks;
        double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        long c = System.currentTimeMillis() / 15L % 360L;
        Color color = Color.getHSBColor((float)c / 360.0f, 1.0f, 1.0f);
        BlockPos p = ItemGraveKey.getTombPos(player.func_70694_bm());
        float x = p.func_177958_n();
        float y = p.func_177956_o();
        float z = p.func_177952_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        GL11.glLineWidth((float)2.5f);
        GlStateManager.func_179123_a();
        GL11.glDisable((int)2929);
        float offset = 1.0f;
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

