/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.packet;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.DeathHandler;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.packet.UpdateClientMessage;

public class UpdateServerMessage
implements IMessage {
    private String graveType;
    private boolean update_client;

    public UpdateServerMessage() {
    }

    public UpdateServerMessage(String graveType, boolean update_client) {
        this.graveType = graveType;
        this.update_client = update_client;
    }

    public void fromBytes(ByteBuf buf) {
        this.graveType = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.update_client = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.graveType);
        buf.writeBoolean(this.update_client);
    }

    public static class Handler
    implements IMessageHandler<UpdateServerMessage, IMessage> {
        public IMessage onMessage(final UpdateServerMessage message, final MessageContext ctx) {
            IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    DeathHandler.getInstance().setFavoriteGrave(player.func_110124_au(), BlockGrave.GraveType.valueOf(message.graveType));
                    if (!message.update_client) {
                        player.func_71064_a((StatBase)AchievementHandler.getAchievement("choose_grave_type"), 1);
                        ArrayList lootList = Lists.newArrayList((Object[])new Block[]{Main.decorative_grave_cross, Main.decorative_grave_normal, Main.decorative_grave_simple, Main.decorative_tombstone});
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Block)lootList.get(Helper.getRandom(0, 3)), 1, 0));
                        player.field_71069_bz.func_75142_b();
                    } else if (player.field_71133_b.func_71262_S()) {
                        DedicatedServer server = (DedicatedServer)player.field_71133_b;
                        BlockPos spawnPos = server.field_71305_c[0].func_175694_M();
                        int range = server.func_82357_ak();
                        PacketHandler.INSTANCE.sendTo((IMessage)new UpdateClientMessage(spawnPos, range), player);
                    }
                }
            });
            return null;
        }
    }
}

