/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockTileEntityGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.ParticleShowItemOver;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ISoulConsumption;
import ovh.corail.tombstone.item.ItemGraveKey;
import ovh.corail.tombstone.packet.UpdateSoulMessage;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class BlockGrave<T extends TileEntityWritableGrave>
extends BlockTileEntityGrave<T> {
    protected final boolean isDecorative;
    protected final GraveType graveType;
    protected final HashMap<EnumFacing, List<AxisAlignedBB>> collisions = new HashMap();

    public BlockGrave(String name, GraveType graveType, boolean isDecorative) {
        super(Material.field_151576_e, name);
        this.isDecorative = isDecorative;
        this.graveType = graveType;
        for (EnumFacing facing : FACING.func_177700_c()) {
            this.collisions.put(facing, Lists.newArrayList());
        }
        this.loadCollisions();
        if (!isDecorative) {
            this.func_149647_a(null);
            this.func_149722_s();
            this.func_149752_b(1.8E7f);
            this.func_149715_a(0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue()) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleShowItemOver(world, Main.soul, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        } else if (world.func_72911_I() && world.field_73017_q > 0.5f && this.canHoldSoul() && Helper.getRandom(1, ConfigurationHandler.chanceSoul) <= 1) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateSoulMessage(pos, true));
        }
        if (!ConfigurationHandler.showFog) {
            return;
        }
        if (this.isDecorative && ((double)world.func_72826_c(0.0f) < 0.245 || (double)world.func_72826_c(0.0f) > 0.755)) {
            return;
        }
        Main.proxy.produceTombstoneParticles(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isDecorative) {
            ItemStack stack;
            if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue() && (stack = player.func_184614_ca()) != null && stack.func_77973_b() instanceof ISoulConsumption) {
                ISoulConsumption item = (ISoulConsumption)stack.func_77973_b();
                if (!item.isEnchanted(stack)) {
                    if (item.setEnchant(world, pos, player, stack)) {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)), 3);
                        SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                        Helper.sendMessage("message.enchant_item.success", player, true);
                    } else {
                        Helper.sendMessage("message.enchant_item.cant_enchant", player, true);
                    }
                } else {
                    Helper.sendMessage("message.enchant_item.already_enchanted", player, true);
                }
            }
            return true;
        }
        TileEntityTombstone tile = (TileEntityTombstone)((Object)this.getTileEntity((IBlockAccess)world, pos));
        if (tile == null) {
            return false;
        }
        boolean valid = false;
        if (!tile.getNeedAccess() || player.func_184812_l_()) {
            valid = true;
        } else if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemGraveKey) {
            ItemStack stack = player.func_184614_ca();
            if (ItemGraveKey.getTombPos(stack).compareTo((Vec3i)tile.func_174877_v()) == 0 && ItemGraveKey.getTombDim(stack) == world.field_73011_w.getDimension()) {
                player.func_184611_a(EnumHand.MAIN_HAND, null);
                valid = true;
            } else {
                Helper.sendMessage("message.open_grave.wrong_key", player, true);
            }
        }
        if (valid) {
            tile.giveInventory(player);
        } else {
            Helper.sendMessage("message.open_grave.need_key", player, true);
        }
        return valid;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.isDecorative) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public boolean canHoldSoul() {
        return this.isDecorative;
    }

    @Override
    public T createTileEntity(World world, IBlockState state) {
        return (T)((Object)(this.isDecorative ? new TileEntityWritableGrave() : new TileEntityTombstone()));
    }

    public GraveType getGraveType() {
        return this.graveType;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        List<AxisAlignedBB> collisionList = this.collisions.get(facing);
        for (AxisAlignedBB collision : collisionList) {
            BlockGrave.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)collision);
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn);
    }

    private void loadCollisions() {
        switch (this.graveType) {
            case GRAVE_CROSS: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.40625, 0.125, 0.6875, 0.59375, 0.9375, 0.875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.40625, 0.125, 0.125, 0.59375, 0.9375, 0.3125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.6875, 0.125, 0.40625, 0.875, 0.9375, 0.59375));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.125, 0.125, 0.40625, 0.3125, 0.9375, 0.59375));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.21875, 0.5625, 0.6875, 0.78125, 0.75, 0.875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.21875, 0.5625, 0.125, 0.78125, 0.75, 0.3125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.6875, 0.5625, 0.21875, 0.875, 0.75, 0.78125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.125, 0.5625, 0.21875, 0.3125, 0.75, 0.78125));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.28125, 0.0625, 0.5625, 0.71875, 0.125, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.28125, 0.0625, 0.0, 0.71875, 0.125, 0.4375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.5625, 0.0625, 0.28125, 1.0, 0.125, 0.71875));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.28125, 0.4375, 0.125, 0.71875));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.34375, 0.125, 0.625, 0.65625, 0.1875, 0.9375));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.34375, 0.125, 0.0625, 0.65625, 0.1875, 0.375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.625, 0.125, 0.34375, 0.9375, 0.1875, 0.65625));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0625, 0.125, 0.34375, 0.375, 0.1875, 0.65625));
                break;
            }
            case GRAVE_NORMAL: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.25, 0.875, 0.8125, 0.875, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.25, 0.0, 0.8125, 0.875, 0.125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.875, 0.25, 0.1875, 1.0, 0.875, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.25, 0.1875, 0.125, 0.875, 0.8125));
                break;
            }
            case GRAVE_SIMPLE: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.0625, 0.8125, 0.8125, 0.875, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.875, 0.1875));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.8125, 0.0625, 0.1875, 1.0, 0.875, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 0.1875, 0.875, 0.8125));
                break;
            }
            default: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.03125, 0.0625, 0.21875, 0.96875, 0.64375, 0.96875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.96875, 0.64375, 0.78125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.21875, 0.0625, 0.03125, 0.96875, 0.64375, 0.96875));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.78125, 0.64375, 0.96875));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.09375, 0.21875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.0625, 0.0625, 0.78125, 0.9375, 0.09375, 0.9375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.21875, 0.09375, 0.9375));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.78125, 0.0625, 0.0625, 0.9375, 0.09375, 0.9375));
            }
        }
    }

    private void addCollision(EnumFacing facing, AxisAlignedBB bounds) {
        List<AxisAlignedBB> listCollisions = this.collisions.get(facing);
        listCollisions.add(bounds);
        this.collisions.put(facing, listCollisions);
    }

    public static enum GraveType {
        GRAVE_SIMPLE,
        GRAVE_NORMAL,
        GRAVE_CROSS,
        TOMBSTONE;

    }
}

