/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.handler.AchievementHandler;

public class ItemBlockGrave
extends ItemBlock {
    public ItemBlockGrave(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!ItemBlockGrave.isEngraved(stack)) {
            player.func_71064_a((StatBase)AchievementHandler.getAchievement("create_decorative_grave"), 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        String customName = ItemBlockGrave.getEngravedName(stack);
        if (customName.isEmpty()) {
            super.func_77624_a(stack, player, tooltip, advanced);
        } else {
            tooltip.clear();
            tooltip.add(0, I18n.func_74838_a((String)(stack.func_77977_a() + ".name")));
            tooltip.add(TextFormatting.GRAY + Helper.getTranslation("item.decorative_grave.desc") + "\"" + customName + "\"");
        }
    }

    public static boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (stack == null || engraved_name.isEmpty()) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74778_a("engraved_name", engraved_name);
        nbt.func_82580_o("display");
        stack.func_77982_d(nbt);
        return true;
    }

    public static boolean isEngraved(ItemStack stack) {
        return stack != null && !ItemBlockGrave.getEngravedName(stack).isEmpty();
    }

    public static String getEngravedName(ItemStack stack) {
        return stack == null || !stack.func_77942_o() ? "" : stack.func_77978_p().func_74779_i("engraved_name");
    }
}

