/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.core;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import nightkosh.gravestone.api.GraveStoneAPI;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.CommonProxy;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.DeathHandler;
import ovh.corail.tombstone.handler.EventHandler;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ItemAdvancement001;
import ovh.corail.tombstone.item.ItemAdvancement002;
import ovh.corail.tombstone.item.ItemAdvancement003;
import ovh.corail.tombstone.item.ItemFakeFog;
import ovh.corail.tombstone.item.ItemGraveKey;
import ovh.corail.tombstone.item.ItemScrollOfRecall;
import ovh.corail.tombstone.item.ItemSoul;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@Mod(modid="tombstone", name="Corail Tombstone", version="1.3.6", acceptedMinecraftVersions="[1.9.4]", updateJSON="https://raw.githubusercontent.com/Corail31/tombstone_lite/master/update.json", guiFactory="ovh.corail.tombstone.gui.GuiFactory", dependencies="before:gravestone;before:GraveStone")
public class Main {
    @Mod.Instance(value="tombstone")
    public static Main instance;
    @SidedProxy(clientSide="ovh.corail.tombstone.core.ClientProxy", serverSide="ovh.corail.tombstone.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static CreativeTabs tabTombstone;
    public static BlockGrave grave_simple;
    public static BlockGrave grave_normal;
    public static BlockGrave grave_cross;
    public static BlockGrave tombstone;
    public static ItemGraveKey grave_key;
    public static ItemFakeFog fake_fog;
    public static ItemSoul soul;
    public static ItemScrollOfRecall scroll_of_recall;
    public static BlockGrave decorative_grave_normal;
    public static BlockGrave decorative_grave_simple;
    public static BlockGrave decorative_grave_cross;
    public static BlockGrave decorative_tombstone;
    public static ItemAdvancement001 itemAchievement001;
    public static ItemAdvancement002 itemAchievement002;
    public static ItemAdvancement003 itemAchievement003;
    public static File whitelistFile;
    public static Set<String> whitelist;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        SoundHandler.registerSounds();
        if (proxy.getSide() == Side.SERVER) {
            DeathHandler.getInstance();
        }
        ConfigurationHandler.loadConfig(new File(event.getModConfigurationDirectory(), "tombstone"));
        whitelistFile = new File(ConfigurationHandler.getConfigDir(), "whitelist_blocks.json");
        whitelist = Helper.loadWhitelist(whitelistFile);
        GameRegistry.registerTileEntity(TileEntityWritableGrave.class, (String)"writable_grave");
        GameRegistry.registerTileEntity(TileEntityTombstone.class, (String)"tombstone");
        Helper.register();
        Helper.registerEncodedRecipes();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        AchievementHandler.registerAchievements();
        if ((Loader.isModLoaded((String)"GraveStone") || Loader.isModLoaded((String)"gravestone")) && ConfigurationHandler.handlePlayerDeath && GraveStoneAPI.graveGenerationAtDeath != null) {
            GraveStoneAPI.graveGenerationAtDeath.addPlayerDeathHandler((player, source) -> true);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    static {
        tabTombstone = new CreativeTabs("tombstone"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)decorative_tombstone);
            }

            public String func_78024_c() {
                return "Corail Tombstone";
            }
        };
        grave_simple = new BlockGrave("grave_normal", BlockGrave.GraveType.GRAVE_NORMAL, false);
        grave_normal = new BlockGrave("grave_simple", BlockGrave.GraveType.GRAVE_SIMPLE, false);
        grave_cross = new BlockGrave("grave_cross", BlockGrave.GraveType.GRAVE_CROSS, false);
        tombstone = new BlockGrave("tombstone", BlockGrave.GraveType.TOMBSTONE, false);
        grave_key = new ItemGraveKey();
        fake_fog = new ItemFakeFog();
        soul = new ItemSoul();
        scroll_of_recall = new ItemScrollOfRecall();
        decorative_grave_normal = new BlockGrave("decorative_grave_normal", BlockGrave.GraveType.GRAVE_NORMAL, true);
        decorative_grave_simple = new BlockGrave("decorative_grave_simple", BlockGrave.GraveType.GRAVE_SIMPLE, true);
        decorative_grave_cross = new BlockGrave("decorative_grave_cross", BlockGrave.GraveType.GRAVE_CROSS, true);
        decorative_tombstone = new BlockGrave("decorative_tombstone", BlockGrave.GraveType.TOMBSTONE, true);
        itemAchievement001 = new ItemAdvancement001();
        itemAchievement002 = new ItemAdvancement002();
        itemAchievement003 = new ItemAdvancement003();
        whitelist = new HashSet<String>();
    }
}

