/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import java.util.HashMap;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.packet.SoundMessage;

public class SoundHandler {
    private static HashMap<String, SoundEvent> sounds = new HashMap();

    private SoundHandler() {
    }

    public static void registerSounds() {
        SoundHandler.registerSound("magic_use01");
    }

    private static void registerSound(String soundName) {
        ResourceLocation soundLoc = new ResourceLocation("tombstone", soundName);
        SoundEvent currentSound = (SoundEvent)new SoundEvent(soundLoc).setRegistryName(soundLoc);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)currentSound);
        sounds.put(soundName, currentSound);
    }

    public static SoundEvent getSound(String soundName) {
        SoundEvent currentSound = sounds.get(soundName);
        return currentSound != null ? currentSound : (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("minecraft", soundName));
    }

    public static boolean playSoundAt(String soundName, WorldClient world, BlockPos currentPos) {
        if (!world.field_72995_K) {
            return false;
        }
        SoundEvent currentSound = SoundHandler.getSound(soundName);
        if (currentSound == null) {
            return false;
        }
        world.func_184156_a(currentPos, currentSound, SoundCategory.PLAYERS, 1.0f, 1.0f, true);
        return true;
    }

    public static boolean playSoundAllAround(String name, World world, BlockPos currentPos, double range) {
        if (world.field_72995_K) {
            return false;
        }
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new SoundMessage(name, currentPos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p(), range));
        return true;
    }
}

