/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ISoulConsumption;

public class ItemScrollOfRecall
extends Item
implements ISoulConsumption {
    private static final String name = "scroll_of_recall";

    public ItemScrollOfRecall() {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77637_a(Main.tabTombstone);
        this.func_77625_d(1);
    }

    protected static boolean isStackValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemScrollOfRecall;
    }

    public static boolean setTombPos(ItemStack stack, BlockPos tombPos, int tombDim) {
        if (!ItemScrollOfRecall.isStackValid(stack)) {
            return false;
        }
        NBTStackHelper.setBlockPos(stack, "tombPos", tombPos);
        NBTStackHelper.setInteger(stack, "tombDim", tombDim);
        ItemScrollOfRecall.setUseCount(stack, ConfigurationHandler.scrollOfRecallUseCount);
        return true;
    }

    public static BlockPos getTombPos(ItemStack stack) {
        if (!ItemScrollOfRecall.isStackValid(stack)) {
            return BlockPos.field_177992_a;
        }
        return NBTStackHelper.getBlockPos(stack, "tombPos");
    }

    public static int getTombDim(ItemStack stack) {
        if (!ItemScrollOfRecall.isStackValid(stack)) {
            return Integer.MAX_VALUE;
        }
        return NBTStackHelper.getInteger(stack, "tombDim");
    }

    private static ItemStack setUseCount(ItemStack stack, int useCount) {
        if (ItemScrollOfRecall.isStackValid(stack)) {
            NBTStackHelper.setInteger(stack, "useCount", useCount);
        }
        return stack;
    }

    public static int getUseCount(ItemStack stack) {
        if (!ItemScrollOfRecall.isStackValid(stack)) {
            return 0;
        }
        return NBTStackHelper.getInteger(stack, "useCount");
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer player) {
        player.func_71064_a((StatBase)AchievementHandler.getAchievement("create_magic_scroll"), 1);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return ItemScrollOfRecall.isStackValid(stack) && ItemScrollOfRecall.getTombPos(stack) != BlockPos.field_177992_a;
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!ItemScrollOfRecall.isStackValid(stack)) {
            return false;
        }
        boolean valid = ItemScrollOfRecall.setTombPos(stack, gravePos, world.field_73011_w.getDimension());
        if (valid) {
            player.func_71064_a((StatBase)AchievementHandler.getAchievement("activate_magic_scroll"), 1);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        if (!ItemScrollOfRecall.isStackValid(stack)) {
            return;
        }
        if (!stack.func_77942_o()) {
            list.add(TextFormatting.AQUA + Helper.getTranslation("item.scroll_of_recall.desc1"));
        } else {
            list.add(TextFormatting.WHITE + Helper.getTranslation("item.scroll_of_recall.desc2"));
            int tombDimId = ItemScrollOfRecall.getTombDim(stack);
            BlockPos tombPos = ItemScrollOfRecall.getTombPos(stack);
            String tombDim = tombDimId == 0 ? "The Overworld" : (tombDimId == -1 ? "The Nether" : (tombDimId == -1 ? "The End" : "Unknown Land " + tombDimId));
            list.add(TextFormatting.WHITE + Helper.getTranslation("item.info.dimTitle") + " : " + tombDim);
            list.add(TextFormatting.WHITE + Helper.getTranslation("item.info.posTitle") + " :  " + tombPos.func_177958_n() + ", " + tombPos.func_177956_o() + ", " + tombPos.func_177952_p());
            list.add(TextFormatting.WHITE + Helper.getTranslation("item.info.useCount") + " : " + ItemScrollOfRecall.getUseCount(stack));
            list.add(TextFormatting.AQUA + Helper.getTranslation("item.info.tele"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (ItemScrollOfRecall.isStackValid(stack)) {
            if (((ItemScrollOfRecall)stack.func_77973_b()).isEnchanted(stack)) {
                BlockPos tombPos = ItemScrollOfRecall.getTombPos(stack);
                int tombDim = ItemScrollOfRecall.getTombDim(stack);
                if (world.field_73011_w.getDimension() == tombDim && tombPos.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 10.0) {
                    Helper.sendMessage("message.teleport_near_grave.too_close", player, true);
                    return super.func_77659_a(stack, world, player, hand);
                }
                int useCount = ItemScrollOfRecall.getUseCount(stack) - 1;
                if (useCount <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else {
                    ItemScrollOfRecall.setUseCount(stack, useCount);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                }
                if (useCount >= 0) {
                    TeleportUtils.teleportEntity((Entity)player, tombDim, (double)tombPos.func_177958_n() + 0.5, (double)tombPos.func_177956_o() + 1.05, (double)tombPos.func_177952_p() + 0.5);
                    SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                    Main.proxy.useMagic(world, player.func_180425_c());
                    Helper.sendMessage("message.teleport_near_grave.success", player, true);
                }
                player.func_71064_a((StatBase)AchievementHandler.getAchievement("recall"), 1);
            } else {
                Helper.sendMessage("message.teleport_near_grave.not_activate", player, true);
            }
        }
        return super.func_77659_a(stack, world, player, hand);
    }
}

