/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Date;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.block.BlockFacingGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public abstract class BlockTileEntityGrave<TE extends TileEntityWritableGrave>
extends BlockFacingGrave {
    public static final PropertyBool IS_ENGRAVED = PropertyBool.func_177716_a((String)"is_engraved");

    public BlockTileEntityGrave(Material material, String name) {
        super(material, name);
    }

    public TE getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TE)((Object)((TileEntityWritableGrave)world.func_175625_s(pos)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TE createTileEntity(World var1, IBlockState var2);

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TE tile;
        String engraved_name = "";
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            engraved_name = nbt.func_74779_i("engraved_name");
        }
        if (!engraved_name.isEmpty() && (tile = this.getTileEntity((IBlockAccess)world, pos)) != null) {
            ((TileEntityWritableGrave)((Object)tile)).setOwner(engraved_name, new Date().getTime());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HAS_SOUL, IS_ENGRAVED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TE tile = this.getTileEntity(world, pos);
        return state.func_177226_a((IProperty)IS_ENGRAVED, (Comparable)Boolean.valueOf(tile != null && !((TileEntityWritableGrave)((Object)tile)).getOwnerName().isEmpty()));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TE tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack == null) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }
}

