/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.handler.ConfigurationHandler;

public class ItemBlockGrave
extends ItemBlock {
    public ItemBlockGrave(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean flag) {
        if (ConfigurationHandler.showItemDesc) {
            String customName = ItemBlockGrave.getEngravedName(stack);
            if (customName.isEmpty()) {
                super.func_77624_a(stack, player, tooltip, flag);
                tooltip.add(TextFormatting.GRAY + "\u00a7o" + Helper.getTranslation("message.engravable", TextFormatting.YELLOW + "[" + Helper.getTranslation(Items.field_151042_j.func_77658_a() + ".name").toLowerCase() + "]"));
            } else {
                tooltip.clear();
                tooltip.add(0, Helper.getTranslation(stack.func_77977_a() + ".name"));
                tooltip.add(TextFormatting.GRAY + "\u00a7o" + Helper.getTranslation("message.engraved") + "\"" + customName + "\"");
            }
        }
    }

    public static boolean isStackValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemBlockGrave;
    }

    public static boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (!ItemBlockGrave.isStackValid(stack) || engraved_name.isEmpty()) {
            return false;
        }
        NBTStackHelper.setString(stack, "engraved_name", engraved_name);
        NBTStackHelper.removeKeyName(stack, "display");
        return true;
    }

    public static boolean isEngraved(ItemStack stack) {
        return !ItemBlockGrave.getEngravedName(stack).isEmpty();
    }

    public static String getEngravedName(ItemStack stack) {
        if (!ItemBlockGrave.isStackValid(stack)) {
            return "";
        }
        return NBTStackHelper.getString(stack, "engraved_name");
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

