/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.core;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import nightkosh.gravestone.api.GraveStoneAPI;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.block.BlockDarkMarble;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBTeleportToGrave;
import ovh.corail.tombstone.command.CommandTBTeleportToPlayer;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.core.CommonProxy;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.EventHandler;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.item.ItemGraveKey;
import ovh.corail.tombstone.item.ItemScrollOfKnowledge;
import ovh.corail.tombstone.item.ItemScrollOfPreservation;
import ovh.corail.tombstone.item.ItemScrollOfUnstableIntangibleness;
import ovh.corail.tombstone.item.ItemTabletOfAssistance;
import ovh.corail.tombstone.item.ItemTabletOfRecall;
import ovh.corail.tombstone.potion.PotionGeneric;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@Mod(modid="tombstone", name="Corail Tombstone", version="2.1.4", acceptedMinecraftVersions="[1.10.2]", updateJSON="https://raw.githubusercontent.com/Corail31/tombstone_lite/master/update.json", guiFactory="ovh.corail.tombstone.gui.GuiFactory", dependencies="before:gravestone")
public class Main {
    @Mod.Instance(value="tombstone")
    public static Main instance;
    @SidedProxy(clientSide="ovh.corail.tombstone.core.ClientProxy", serverSide="ovh.corail.tombstone.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static CreativeTabs tabTombstone;
    public static BlockGrave grave_simple;
    public static BlockGrave grave_normal;
    public static BlockGrave grave_cross;
    public static BlockGrave tombstone;
    public static BlockGrave decorative_grave_normal;
    public static BlockGrave decorative_grave_simple;
    public static BlockGrave decorative_grave_cross;
    public static BlockGrave decorative_tombstone;
    public static Block dark_marble;
    public static ItemGraveKey grave_key;
    public static ItemScrollOfKnowledge scroll_of_knowledge;
    public static ItemScrollOfPreservation scroll_of_preservation;
    public static ItemScrollOfUnstableIntangibleness scroll_of_unstable_intangibleness;
    public static ItemTabletOfRecall tablet_of_recall;
    public static ItemTabletOfAssistance tablet_of_assistance;
    public static Item fake_fog;
    public static Item soul;
    public static Item strange_scroll;
    public static Item strange_tablet;
    public static Item grave_dust;
    public static Item advancement_001;
    public static Item advancement_002;
    public static Item advancement_003;
    public static Item advancement_004;
    public static Item advancement_005;
    public static Item advancement_006;
    public static Potion potionGhostlyShape;
    public static Potion potionPreservation;
    public static Potion potionUnstableIntangibleness;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        SoundHandler.registerSounds();
        ConfigurationHandler.loadConfig(new File(event.getModConfigurationDirectory(), "tombstone"));
        GameRegistry.registerTileEntity(TileEntityWritableGrave.class, (String)"writable_grave");
        GameRegistry.registerTileEntity(TileEntityTombstone.class, (String)"tombstone");
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"dustGrave", (Item)grave_dust);
        Helper.registerEncodedRecipes();
        proxy.init(event);
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("tombstone", "grave_dust"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("tombstone", "random_undead_skull"));
        AchievementHandler.getInstance().registerAchievements();
        if (ConfigurationHandler.handlePlayerDeath && CompatibilityGraveStone.getInstance().isNightKosh() && GraveStoneAPI.graveGenerationAtDeath != null) {
            GraveStoneAPI.graveGenerationAtDeath.addPlayerDeathHandler((player, source) -> true);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTBTeleportToPlayer());
        event.registerServerCommand((ICommand)new CommandTBTeleportToGrave());
        event.registerServerCommand((ICommand)new CommandTBShowLastGrave());
    }

    static {
        tabTombstone = new CreativeTabs("tombstone"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)decorative_tombstone);
            }

            public String func_78024_c() {
                return "Corail Tombstone";
            }
        };
        grave_simple = new BlockGrave("grave_normal", BlockGrave.GraveType.GRAVE_NORMAL, false);
        grave_normal = new BlockGrave("grave_simple", BlockGrave.GraveType.GRAVE_SIMPLE, false);
        grave_cross = new BlockGrave("grave_cross", BlockGrave.GraveType.GRAVE_CROSS, false);
        tombstone = new BlockGrave("tombstone", BlockGrave.GraveType.TOMBSTONE, false);
        decorative_grave_normal = new BlockGrave("decorative_grave_normal", BlockGrave.GraveType.GRAVE_NORMAL, true);
        decorative_grave_simple = new BlockGrave("decorative_grave_simple", BlockGrave.GraveType.GRAVE_SIMPLE, true);
        decorative_grave_cross = new BlockGrave("decorative_grave_cross", BlockGrave.GraveType.GRAVE_CROSS, true);
        decorative_tombstone = new BlockGrave("decorative_tombstone", BlockGrave.GraveType.TOMBSTONE, true);
        dark_marble = new BlockDarkMarble();
        grave_key = new ItemGraveKey();
        scroll_of_knowledge = new ItemScrollOfKnowledge();
        scroll_of_preservation = new ItemScrollOfPreservation();
        scroll_of_unstable_intangibleness = new ItemScrollOfUnstableIntangibleness();
        tablet_of_recall = new ItemTabletOfRecall();
        tablet_of_assistance = new ItemTabletOfAssistance();
        fake_fog = new ItemGeneric("fake_fog", false, false);
        soul = new ItemGeneric("soul", false, false);
        strange_scroll = new ItemGeneric("strange_scroll", true, false, true);
        strange_tablet = new ItemGeneric("strange_tablet", true, false, true);
        grave_dust = new ItemGeneric("grave_dust", true, false, true);
        advancement_001 = new ItemGeneric("advancement_001", false, true);
        advancement_002 = new ItemGeneric("advancement_002", false, true);
        advancement_003 = new ItemGeneric("advancement_003", false, true);
        advancement_004 = new ItemGeneric("advancement_004", false, true);
        advancement_005 = new ItemGeneric("advancement_005", false, false);
        advancement_006 = new ItemGeneric("advancement_006", false, true);
        potionGhostlyShape = new PotionGeneric("ghostly_shape", false, 2331802);
        potionPreservation = new PotionGeneric("preservation", false, 0x9999FF);
        potionUnstableIntangibleness = new PotionGeneric("unstable_intangibleness", false, 13095155);
    }
}

