/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.core;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class NBTStackHelper {
    private static boolean checkCompound(ItemStack stack, boolean addCompound) {
        if (stack == null) {
            return false;
        }
        if (addCompound && !stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77942_o();
    }

    private static boolean checkCompound(ItemStack stack) {
        return NBTStackHelper.checkCompound(stack, false);
    }

    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74778_a(keyName, keyValue);
        }
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74779_i(keyName);
        }
        return "";
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74757_a(keyName, keyValue);
        }
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74767_n(keyName);
        }
        return false;
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74768_a(keyName, keyValue);
        }
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74762_e(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            stack.func_77978_p().func_74772_a(keyName, keyValue);
        }
        return stack;
    }

    public static long getLong(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = stack.func_77978_p()).func_74764_b(keyName)) {
            return compound.func_74763_f(keyName);
        }
        return Long.MIN_VALUE;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setInteger(stack, keyName + "X", keyValue.func_177958_n());
        NBTStackHelper.setInteger(stack, keyName + "Y", keyValue.func_177956_o());
        NBTStackHelper.setInteger(stack, keyName + "Z", keyValue.func_177952_p());
        return stack;
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        int intValueX = NBTStackHelper.getInteger(stack, keyName + "X");
        int intValueY = NBTStackHelper.getInteger(stack, keyName + "Y");
        int intValueZ = NBTStackHelper.getInteger(stack, keyName + "Z");
        if (intValueX != Integer.MIN_VALUE && intValueY != Integer.MIN_VALUE && intValueZ != Integer.MIN_VALUE) {
            return new BlockPos(intValueX, intValueY, intValueZ);
        }
        long longValue = NBTStackHelper.getLong(stack, keyName);
        return longValue != Long.MIN_VALUE ? BlockPos.func_177969_a((long)longValue) : BlockPos.field_177992_a;
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        if (NBTStackHelper.hasKeyName(stack, keyName)) {
            stack.func_77978_p().func_82580_o(keyName);
            return true;
        }
        return false;
    }

    public static boolean hasKeyName(ItemStack stack, String keyName) {
        if (NBTStackHelper.checkCompound(stack)) {
            return stack.func_77978_p().func_74764_b(keyName);
        }
        return false;
    }
}

