/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.AchievementPage;
import ovh.corail.tombstone.core.Main;

public class AchievementHandler {
    private static final AchievementHandler instance = new AchievementHandler();
    private static Map<String, Achievement> achievements = new HashMap<String, Achievement>();
    private static Map<String, String> rewards = new HashMap<String, String>();
    private static int achievementCount = 0;

    private AchievementHandler() {
    }

    public static AchievementHandler getInstance() {
        return instance;
    }

    private void initAchievements() {
        this.addAchievement("tutorial/tutorial", 0, 0, Main.decorative_tombstone, null, AchievType.CHALLENGE);
        this.addAchievement("tutorial/first_grave", 0, -1, Main.advancement_001, "tutorial/tutorial", AchievType.TASK);
        this.addAchievement("tutorial/cancel_ghostly_shape", -1, -2, Main.advancement_005, "tutorial/first_grave", AchievType.GOAL, "grave_dust");
        this.addAchievement("tutorial/upgrade_grave_key", 1, -2, Main.grave_key, "tutorial/first_grave", AchievType.TASK);
        this.addAchievement("tutorial/teleport_to_grave", 2, -3, Main.advancement_002, "tutorial/upgrade_grave_key", AchievType.GOAL);
        this.addAchievement("tutorial/choose_grave_type", 0, 1, Main.decorative_grave_cross, "tutorial/tutorial", AchievType.GOAL, "random_undead_skull");
        this.addAchievement("tutorial/find_grave_dust", 1, 0, Main.grave_dust, "tutorial/tutorial", AchievType.TASK);
        this.addAchievement("tutorial/create_dark_marble", 2, 0, Main.dark_marble, "tutorial/find_grave_dust", AchievType.TASK, "grave_dust");
        this.addAchievement("tutorial/create_decorative_grave", 3, 0, Main.decorative_grave_simple, "tutorial/create_dark_marble", AchievType.GOAL);
        this.addAchievement("tutorial/engrave_decorative_grave", 3, 1, Blocks.field_150467_bQ, "tutorial/create_decorative_grave", AchievType.GOAL);
        this.addAchievement("tutorial/create_strange_scroll", 4, -1, Main.strange_scroll, "tutorial/create_decorative_grave", AchievType.TASK);
        this.addAchievement("tutorial/create_strange_tablet", 4, 1, Main.strange_tablet, "tutorial/create_decorative_grave", AchievType.TASK);
        this.addAchievement("tutorial/create_magic_scroll", 5, -1, Main.advancement_003, "tutorial/create_strange_scroll", AchievType.TASK);
        this.addAchievement("tutorial/create_magic_tablet", 5, 1, Main.advancement_006, "tutorial/create_strange_tablet", AchievType.TASK);
        this.addAchievement("tutorial/activate_magic_item", 6, 0, Main.soul, "tutorial/create_decorative_grave", AchievType.TASK);
        this.addAchievement("tutorial/use_knowledge", 7, -1, Main.scroll_of_knowledge, "tutorial/activate_magic_item", AchievType.GOAL);
        this.addAchievement("tutorial/use_preservation", 7, -2, Main.scroll_of_preservation, "tutorial/activate_magic_item", AchievType.GOAL);
        this.addAchievement("tutorial/use_recall", 7, 1, Main.tablet_of_recall, "tutorial/activate_magic_item", AchievType.GOAL);
        this.addAchievement("tutorial/use_assistance", 7, 2, Main.tablet_of_assistance, "tutorial/activate_magic_item", AchievType.GOAL);
        this.addAchievement("tutorial/use_unstable_intangibleness", 7, -3, Main.scroll_of_unstable_intangibleness, "tutorial/activate_magic_item", AchievType.GOAL);
    }

    private void addAchievement(String name, int col, int row, Block block, String parent, AchievType type) {
        this.addAchievement(name, col, row, new ItemStack(block), parent, type, "");
    }

    private void addAchievement(String name, int col, int row, Block block, String parent, AchievType type, String reward) {
        this.addAchievement(name, col, row, new ItemStack(block), parent, type, reward);
    }

    private void addAchievement(String name, int col, int row, Item item, String parent, AchievType type) {
        this.addAchievement(name, col, row, new ItemStack(item), parent, type, "");
    }

    private void addAchievement(String name, int col, int row, Item item, String parent, AchievType type, String reward) {
        this.addAchievement(name, col, row, new ItemStack(item), parent, type, reward);
    }

    private void addAchievement(String name, int col, int row, ItemStack icon, String parent, AchievType type, String reward) {
        AchievementTombstone achiev = new AchievementTombstone("tombstone.achievement." + name, name.split("/")[1], row, col, icon, achievements.get(parent), type);
        achievements.put(name, achiev.func_75971_g());
        ++achievementCount;
        rewards.put(name, reward);
    }

    public Achievement getAchievement(String name) {
        return achievements.get(name);
    }

    public String getReward(String name) {
        return rewards.get(name);
    }

    public void registerAchievements() {
        this.initAchievements();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("tombstone", achievements.values().toArray(new Achievement[achievements.values().size()])));
    }

    public class AchievementTombstone
    extends Achievement {
        public final AchievType type;

        public AchievementTombstone(String name, String unlocalizedName, int col, int row, ItemStack icon, Achievement parent, AchievType type) {
            super(name, unlocalizedName, col, row, icon, parent);
            this.type = type;
            if (this.func_75984_f()) {
                this.func_75987_b();
            }
        }

        public AchievementTombstone(String name, String unlocalizedName, int col, int row, Block icon, Achievement parent, AchievType type) {
            this(name, unlocalizedName, col, row, new ItemStack(icon), parent, type);
        }

        public AchievementTombstone(String name, String unlocalizedName, int col, int row, Item icon, Achievement parent, AchievType type) {
            this(name, unlocalizedName, col, row, new ItemStack(icon), parent, type);
        }

        public boolean func_75984_f() {
            return this.type == AchievType.CHALLENGE;
        }

        public ITextComponent func_150951_e() {
            TextFormatting color;
            switch (this.type) {
                case CHALLENGE: {
                    if (this.field_75992_c == null) {
                        color = TextFormatting.DARK_GRAY;
                        break;
                    }
                    color = TextFormatting.DARK_PURPLE;
                    break;
                }
                case GOAL: {
                    color = TextFormatting.YELLOW;
                    break;
                }
                default: {
                    color = TextFormatting.GREEN;
                }
            }
            ITextComponent itextcomponent = super.func_150951_e();
            itextcomponent.func_150256_b().func_150238_a(color);
            return itextcomponent;
        }
    }

    public static enum AchievType {
        TASK,
        GOAL,
        CHALLENGE;

    }
}

