/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import java.io.File;
import java.util.stream.Stream;
import net.minecraftforge.common.config.Configuration;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.Helper;
import scala.Int;

public class ConfigurationHandler {
    public static Configuration config;
    private static File configDir;
    public static String lastFavoriteGrave;
    public static boolean handlePlayerDeath;
    public static boolean restoreEffectsOnDeath;
    public static boolean logPlayerGrave;
    public static boolean playerGraveAccess;
    public static boolean graveKeyOnDeath;
    public static boolean upgradeGraveKey;
    public static boolean highlight;
    public static boolean teleportDim;
    public static boolean showFog;
    public static boolean pvpMode;
    public static boolean undeadCanDropSkull;
    public static boolean showItemDesc;
    public static boolean showItemUse;
    public static boolean unbreakableDecorativeGrave;
    public static String favoriteGrave;
    public static int xpLoss;
    public static int decayTime;
    public static int tabletUseCount;
    public static int textColorRIP;
    public static int textColorOwner;
    public static int textColorDeathDate;
    public static int snifferRange;
    public static int graveRange;
    public static int ghostlyShapeDuration;
    public static float chanceGraveSoul;
    public static float chanceGraveDust;
    public static boolean serverUnbreakableDecorativeGrave;

    private ConfigurationHandler() {
    }

    public static void refreshConfig() {
        handlePlayerDeath = config.getBoolean("handlePlayerDeath", "general", true, Helper.getTranslation("config.handlePlayerDeath"));
        restoreEffectsOnDeath = config.getBoolean("restoreEffectsonDeath", "general", false, Helper.getTranslation("config.restoreEffectsonDeath"));
        logPlayerGrave = config.getBoolean("logPlayerGrave", "general", false, Helper.getTranslation("config.logPlayerGrave"));
        playerGraveAccess = config.getBoolean("playerGraveAccess", "general", true, Helper.getTranslation("config.playerGraveAccess"));
        graveKeyOnDeath = config.getBoolean("graveKeyOnDeath", "general", true, Helper.getTranslation("config.graveKeyOnDeath"));
        upgradeGraveKey = config.getBoolean("upgradeGraveKey", "general", true, Helper.getTranslation("config.upgradeGraveKey"));
        xpLoss = config.getInt("xpLoss", "general", 0, 25, 100, Helper.getTranslation("config.xpLoss"));
        decayTime = config.getInt("decayTime", "general", -1, -1, Int.MaxValue(), Helper.getTranslation("config.decayTime"));
        teleportDim = config.getBoolean("teleportDim", "general", true, Helper.getTranslation("config.teleportDim"));
        pvpMode = config.getBoolean("pvpMode", "general", false, Helper.getTranslation("config.pvpMode"));
        tabletUseCount = config.getInt("tabletUseCount", "general", 3, 1, 10, Helper.getTranslation("config.tabletUseCount"));
        snifferRange = config.getInt("snifferRange", "general", 5, 0, 10, Helper.getTranslation("config.snifferRange"));
        graveRange = config.getInt("graveRange", "general", 2, 0, 5, Helper.getTranslation("config.graveRange"));
        ghostlyShapeDuration = config.getInt("ghostlyShapeDuration", "general", 120, 0, 600, Helper.getTranslation("config.ghostlyShapeDuration"));
        chanceGraveSoul = config.getInt("chanceGraveSoul", "general", 4, 0, 200, Helper.getTranslation("config.chanceGraveSoul"));
        chanceGraveDust = config.getInt("chanceGraveDust", "general", 100, 0, 1000, Helper.getTranslation("config.chanceGraveDust"));
        undeadCanDropSkull = config.getBoolean("undeadCanDropSkull", "general", true, Helper.getTranslation("config.undeadCanDropSkull"));
        unbreakableDecorativeGrave = config.getBoolean("unbreakableDecorativeGrave", "general", false, Helper.getTranslation("unbreakableDecorativeGrave"));
        String[] allowValues = (String[])Stream.of(BlockGrave.GraveType.values()).map(Enum::name).toArray(String[]::new);
        favoriteGrave = config.getString("favoriteGrave", "client", BlockGrave.GraveType.TOMBSTONE.toString(), Helper.getTranslation("config.favoriteGrave"), allowValues);
        highlight = config.getBoolean("highlight", "client", true, Helper.getTranslation("config.highlight"));
        showFog = config.getBoolean("showFog", "client", true, Helper.getTranslation("config.showFog"));
        textColorRIP = config.getInt("textColorRIP", "client", 2962496, 0, 0xFFFFFF, Helper.getTranslation("config.textColorRIP"));
        textColorOwner = config.getInt("textColorOwner", "client", 5991302, 0, 0xFFFFFF, Helper.getTranslation("config.textColorOwner"));
        textColorDeathDate = config.getInt("textColorDeathDate", "client", 2962496, 0, 0xFFFFFF, Helper.getTranslation("config.textColorDeathDate"));
        showItemDesc = config.getBoolean("showItemDesc", "client", true, Helper.getTranslation("showItemDesc"));
        showItemUse = config.getBoolean("showItemUse", "client", true, Helper.getTranslation("showItemUse"));
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void loadConfig(File configDir) {
        ConfigurationHandler.configDir = configDir;
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        config = new Configuration(new File(configDir, "tombstone.cfg"), "2.1.4");
        config.load();
        ConfigurationHandler.refreshConfig();
        lastFavoriteGrave = favoriteGrave;
    }

    public static File getConfigDir() {
        return configDir;
    }

    static {
        serverUnbreakableDecorativeGrave = false;
    }
}

