/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.BlockPosDim;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.ConfigurationHandler;

public class DeathHandler {
    private static final DeathHandler instance = new DeathHandler();
    private HashMap<UUID, BlockGrave.GraveType> favorite_graves = new HashMap();
    private HashMap<UUID, List<PotionEffect>> playerDeadNICList = new HashMap();
    private HashSet<String> blackListEffects = new HashSet();
    private HashSet<String> whiteListBlocks = new HashSet();
    private HashMap<String, BlockPosDim> lastGraveList = new HashMap();

    private DeathHandler() {
        this.init();
    }

    public static DeathHandler getInstance() {
        return instance;
    }

    public List<String> getLastGraveList() {
        return Lists.newArrayList(this.lastGraveList.keySet());
    }

    public BlockPosDim getLastGrave(String playerName) {
        return this.lastGraveList.get(playerName);
    }

    public void removeGrave(BlockPosDim pos) {
        Iterator<Map.Entry<String, BlockPosDim>> it = this.lastGraveList.entrySet().iterator();
        while (it.hasNext()) {
            BlockPosDim gravePos = it.next().getValue();
            if (!gravePos.equals(pos)) continue;
            it.remove();
        }
    }

    public void logLastGrave(EntityPlayer player, int x, int y, int z, int dim) {
        if (player == null) {
            return;
        }
        this.lastGraveList.put(player.func_70005_c_(), new BlockPosDim(x, y, z, dim));
        if (ConfigurationHandler.logPlayerGrave) {
            Helper.sendLog("The grave of [" + player.func_70005_c_() + "] has been set at pos [" + x + ", " + y + ", " + z + "] in dim [" + dim + "]");
        }
    }

    private void init() {
        File fileBlocks = new File(ConfigurationHandler.getConfigDir(), "whitelist_blocks.json");
        if (fileBlocks.exists()) {
            this.whiteListBlocks = Helper.loadAsJson(fileBlocks, String.class);
        } else {
            this.whiteListBlocks.add("minecraft:tallgrass:0");
            this.whiteListBlocks.add("minecraft:tallgrass:1");
            this.whiteListBlocks.add("minecraft:tallgrass:2");
            this.whiteListBlocks.add("minecraft:deadbush:0");
            this.whiteListBlocks.add("minecraft:double_plant:0");
            this.whiteListBlocks.add("minecraft:double_plant:1");
            this.whiteListBlocks.add("minecraft:double_plant:2");
            this.whiteListBlocks.add("minecraft:double_plant:3");
            this.whiteListBlocks.add("minecraft:double_plant:4");
            this.whiteListBlocks.add("minecraft:double_plant:5");
            this.whiteListBlocks.add("minecraft:snow_layer:0");
            Helper.saveAsJson(fileBlocks, this.whiteListBlocks);
        }
        File fileEffects = new File(ConfigurationHandler.getConfigDir(), "blacklist_effects.json");
        if (fileEffects.exists()) {
            this.blackListEffects = Helper.loadAsJson(fileEffects, String.class);
            this.blackListEffects.add("tombstone:ghostly_shape");
            this.blackListEffects.add("tombstone:preservation");
        } else {
            this.blackListEffects.add("tombstone:ghostly_shape");
            Helper.saveAsJson(fileEffects, this.blackListEffects);
        }
    }

    public boolean isSafeBlock(World world, BlockPos currentPos) {
        IBlockState state = world.func_180495_p(currentPos);
        Block block = state.func_177230_c();
        if (!world.func_175701_a(currentPos)) {
            return false;
        }
        if (!world.func_175667_e(currentPos)) {
            return false;
        }
        if (world.func_175625_s(currentPos) != null) {
            return false;
        }
        if (world.func_175623_d(currentPos)) {
            return true;
        }
        return this.whiteListBlocks.contains(block.getRegistryName().toString() + ":" + block.func_176201_c(state));
    }

    public BlockPos getSafePos(World world, final BlockPos middlePos, int range) {
        boolean isCubicChunksLoaded = Loader.isModLoaded((String)"cubicchunks");
        int maxDistance = !isCubicChunksLoaded ? 255 : 300 + middlePos.func_177956_o();
        ArrayList positions = Lists.newArrayList();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                positions.add(middlePos.func_177982_a(x, 0, z));
            }
        }
        positions.sort(new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos pos0, BlockPos pos1) {
                double dist1;
                double dist0 = pos0.func_177954_c((double)middlePos.func_177958_n(), (double)middlePos.func_177956_o(), (double)middlePos.func_177952_p());
                if (dist0 < (dist1 = pos1.func_177954_c((double)middlePos.func_177958_n(), (double)middlePos.func_177956_o(), (double)middlePos.func_177952_p()))) {
                    return -1;
                }
                if (dist0 > dist1) {
                    return 1;
                }
                return 0;
            }
        });
        BlockPos currentPos = middlePos;
        while (currentPos.func_177956_o() < maxDistance) {
            for (BlockPos pos : positions) {
                if (!this.isSafeBlock(world, new BlockPos(pos.func_177958_n(), currentPos.func_177956_o(), pos.func_177952_p()))) continue;
                return pos;
            }
            currentPos = currentPos.func_177984_a();
        }
        return null;
    }

    public void addPlayerDeadNIC(EntityPlayer player) {
        UUID playerUUID = player.func_110124_au();
        ArrayList effectsList = Lists.newArrayList();
        if (ConfigurationHandler.restoreEffectsOnDeath || Helper.isPotionActive(player, Main.potionPreservation)) {
            for (PotionEffect effect : player.func_70651_bq()) {
                if (!this.isAllowedEffect(effect)) continue;
                effectsList.add(effect);
            }
        }
        this.playerDeadNICList.put(playerUUID, effectsList);
    }

    public boolean isAllowedEffect(PotionEffect effect) {
        return !this.blackListEffects.contains(effect.func_76453_d()) && effect.func_188419_a().func_188408_i();
    }

    public void restorePlayerDeadNIC(EntityPlayer player) {
        if (!this.isPlayerDeadNIC(player)) {
            return;
        }
        if (ConfigurationHandler.ghostlyShapeDuration > 0) {
            Helper.addPotion(player, Main.potionGhostlyShape, ConfigurationHandler.ghostlyShapeDuration * 20);
        }
        UUID playerUUID = player.func_110124_au();
        if (ConfigurationHandler.restoreEffectsOnDeath || Helper.isPotionActive(player, Main.potionPreservation)) {
            List<PotionEffect> effectsList = this.playerDeadNICList.get(playerUUID);
            for (PotionEffect effect : effectsList) {
                if (!this.isAllowedEffect(effect)) continue;
                PotionEffect activeEffect = player.func_70660_b(effect.func_188419_a());
                if (activeEffect != null) {
                    if (activeEffect.func_76459_b() >= effect.func_76459_b()) continue;
                    player.func_184589_d(activeEffect.func_188419_a());
                }
                player.func_70690_d(effect);
            }
        }
        this.playerDeadNICList.remove(playerUUID);
    }

    private boolean isPlayerDeadNIC(EntityPlayer player) {
        return this.playerDeadNICList.containsKey(player.func_110124_au());
    }

    public void setFavoriteGrave(UUID id, BlockGrave.GraveType type) {
        EntityPlayerMP player;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        PlayerList playerList = server.func_184103_al();
        if (playerList != null && (player = playerList.func_177451_a(id)) != null && type != null) {
            this.favorite_graves.put(id, type);
        }
    }

    public BlockGrave.GraveType getFavoriteGrave(UUID id) {
        BlockGrave.GraveType type = this.favorite_graves.get(id);
        return type == null ? BlockGrave.GraveType.TOMBSTONE : type;
    }

    public Block getFavoriteGraveBlock(UUID id) {
        BlockGrave.GraveType graveType = this.getFavoriteGrave(id);
        switch (graveType) {
            case GRAVE_CROSS: {
                return Main.grave_cross;
            }
            case GRAVE_NORMAL: {
                return Main.grave_normal;
            }
            case GRAVE_SIMPLE: {
                return Main.grave_simple;
            }
        }
        return Main.tombstone;
    }

    public void handleMobDrops(EntityLivingBase entity, List<EntityItem> drops) {
        if (entity.func_70662_br()) {
            if ((float)Helper.getRandom(1, 1000) <= ConfigurationHandler.chanceGraveDust) {
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(Main.grave_dust, Helper.getRandom(1, 2))));
            }
            if (ConfigurationHandler.undeadCanDropSkull && (entity instanceof EntitySkeleton || entity instanceof EntityZombie) && Helper.getRandom(1, 1000) <= 5) {
                ItemStack skullStack = new ItemStack(Items.field_151144_bL, 1, entity instanceof EntitySkeleton ? 0 : 2);
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, skullStack));
            }
        }
    }
}

