/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;

public abstract class ItemGraveMagic
extends Item {
    protected final String name;

    public ItemGraveMagic(String name) {
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.name = name;
        this.func_77637_a(Main.tabTombstone);
        this.func_77625_d(1);
    }

    public abstract boolean isEnchanted(ItemStack var1);

    public abstract boolean setEnchant(World var1, BlockPos var2, EntityPlayer var3, ItemStack var4);

    protected abstract boolean doEffects(World var1, EntityPlayer var2, ItemStack var3);

    public boolean isStackValid(ItemStack stack) {
        return stack != null && ((Object)((Object)this)).getClass().isInstance(stack.func_77973_b());
    }

    public String getEnchantSuccessMessage() {
        return "message.enchant_item.success";
    }

    public String getEnchantFailedMessage() {
        return "message.enchant_item.cant_enchant";
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        if (this.isEnchanted(stack)) {
            int cd;
            if (this.canConsumeOnUse()) {
                list.add(TextFormatting.WHITE + Helper.getTranslation("message.use_left") + " : " + this.getUseCount(stack));
            }
            if ((cd = this.getCooldown(player.field_70170_p, stack) / 20) > 1) {
                String min = String.format("%1$3s", cd / 60);
                String sec = String.format("%1$2s", cd % 60);
                list.add(TextFormatting.RED + Helper.getTranslation("message.in_cooldown", min, sec));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack heldItem, World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isEnchanted(stack) && !this.isCooldown(world, stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
        if (player.field_70170_p.field_72995_K && this.isEnchanted(stack)) {
            double posX = player.field_70165_t + (double)(Helper.getRandom() ? -1.0f : 1.0f);
            double posY = player.field_70163_u + Helper.getRandom(0.3, 0.7);
            double posZ = player.field_70161_v + (double)(Helper.getRandom() ? -1.0f : 1.0f);
            player.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, posX, posY, posZ, 0.1, 0.1, 0.1, new int[0]);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (this.isEnchanted(stack)) {
                int useCount = this.getUseCount(stack);
                if (useCount < 0) {
                    return null;
                }
                if (this.doEffects(world, player, stack)) {
                    SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                    if (!this.canConsumeOnUse() || --useCount > 0) {
                        this.setCooldown(world, stack, this.getCastingCooldown());
                        this.setUseCount(stack, useCount);
                        return stack;
                    }
                    return null;
                }
                return stack;
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 50;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public abstract int getCastingCooldown();

    public boolean isCooldown(World world, ItemStack stack) {
        return this.getCooldown(world, stack) > 0;
    }

    public int getCooldown(World world, ItemStack stack) {
        long worldTime;
        if (!this.isStackValid(stack) || world == null) {
            return 0;
        }
        long cooldownTime = NBTStackHelper.getLong(stack, "cooldown_time");
        return cooldownTime > (worldTime = world.func_82737_E()) ? (int)(cooldownTime - worldTime) : 0;
    }

    public void setCooldown(World world, ItemStack stack, int time) {
        if (this.isStackValid(stack) && world != null && time > this.getCooldown(world, stack)) {
            NBTStackHelper.setLong(stack, "cooldown_time", world.func_82737_E() + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return NBTStackHelper.getInteger(stack, "useCount");
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, "useCount", useCount);
        }
        return stack;
    }

    public void addItemDesc(List<String> list, int id, Object ... format) {
        if (ConfigurationHandler.showItemDesc) {
            list.add(TextFormatting.GRAY + "\u00a7o" + Helper.getTranslation("item." + this.name + ".desc" + id, format));
        }
    }

    public void addItemUse(List<String> list, int id, Object ... format) {
        if (ConfigurationHandler.showItemUse) {
            list.add(TextFormatting.DARK_PURPLE + "\u00a7o" + Helper.getTranslation("item." + this.name + ".use" + id, format));
        }
    }
}

