/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;

public class ItemScrollOfKnowledge
extends ItemScroll {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge");
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        int id = this.isEnchanted(stack) ? 2 : 1;
        this.addItemDesc(list, id, new Object[0]);
        if (id == 2) {
            list.add(TextFormatting.WHITE + Helper.getTranslation("message.stored_xp") + " : " + this.getStoredXp(stack));
        }
        this.addItemUse(list, id, new Object[0]);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public String getEnchantSuccessMessage() {
        return "message.loose_experience";
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        boolean valid = this.setStoredXp(stack, player.field_71067_cb);
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
        }
        return valid;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayer player, ItemStack stack) {
        player.func_71023_q(this.getStoredXp(stack));
        Helper.sendMessage("message.earn_experience", player, true);
        Helper.grantAdvancement(player, "tutorial/use_knowledge");
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        int storedXp = NBTStackHelper.getInteger(stack, "stored_xp");
        return storedXp > 0 ? storedXp : 0;
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (!this.isStackValid(stack) || xp <= 0) {
            return false;
        }
        NBTStackHelper.setInteger(stack, "stored_xp", xp);
        return true;
    }
}

