/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@SideOnly(value=Side.CLIENT)
public class RenderWritableGrave
extends TileEntitySpecialRenderer<TileEntityWritableGrave> {
    public void renderTileEntityAt(TileEntityWritableGrave te, double x, double y, double z, float partialTicks, int destroyStage) {
        float value;
        if (te == null || te.getOwnerName().isEmpty()) {
            return;
        }
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockGrave)) {
            return;
        }
        BlockGrave block = (BlockGrave)state.func_177230_c();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockGrave.FACING);
        int rotationIndex = 0;
        float modX = 0.5f;
        float modY = 0.5f;
        float modZ = 0.5f;
        switch (block.getGraveType()) {
            case GRAVE_CROSS: {
                value = 0.25f;
                modY = 0.06375f;
                break;
            }
            case GRAVE_NORMAL: {
                value = 0.12625f;
                modY = 0.5f;
                break;
            }
            case GRAVE_SIMPLE: {
                value = 0.18875f;
                modY = 0.4f;
                break;
            }
            default: {
                value = 0.56375f;
                modY = 0.25f;
            }
        }
        boolean is_cross = block.getGraveType() == BlockGrave.GraveType.GRAVE_CROSS;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (is_cross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (is_cross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (is_cross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = is_cross ? value : 1.0f - value;
            }
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)((float)x + modX), (float)((float)y + modY), (float)((float)z + modZ));
        GlStateManager.func_179114_b((float)(90.0f * (float)rotationIndex), (float)0.0f, (float)1.0f, (float)0.0f);
        if (is_cross) {
            GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179132_a((boolean)false);
        FontRenderer fontRender = this.func_147498_b();
        GlStateManager.func_179094_E();
        float scale = 0.007f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + "R.I.P.", fontRender, 0, ConfigurationHandler.textColorRIP + -16777216);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        scale = 0.005f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        boolean textPos = false;
        this.showString(TextFormatting.BOLD + te.getOwnerName(), fontRender, 11, ConfigurationHandler.textColorOwner + -16777216);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        scale = 0.004f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        int textColorDeathDate = ConfigurationHandler.textColorDeathDate + -16777216;
        this.showString(TextFormatting.BOLD + Helper.getTranslation("message.death_date.died_on"), fontRender, 26, textColorDeathDate);
        this.showString(TextFormatting.BOLD + te.getOwnerDeathDate(1, false), fontRender, 36, textColorDeathDate);
        this.showString(TextFormatting.BOLD + te.getOwnerDeathDate(2, true), fontRender, 46, textColorDeathDate);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private void showString(String content, FontRenderer fontRenderer, int posY, int color) {
        fontRenderer.func_175065_a(content, (float)(-fontRenderer.func_78256_a(content) / 2), (float)(posY - 30), color, true);
    }
}

