/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.ConfigurationHandler;

public class TileEntityWritableGrave
extends TileEntity
implements ITickable {
    protected String ownerName = "";
    protected long deathDate;
    private int countTicks = 0;

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockGrave)) {
            return;
        }
        BlockGrave grave = (BlockGrave)state.func_177230_c();
        boolean hasSoul = (Boolean)state.func_177229_b((IProperty)BlockGrave.HAS_SOUL);
        if (this.field_145850_b.field_72995_K) {
            if (hasSoul && this.countTicks % 100 == 0) {
                Main.proxy.produceGraveSoul(this.field_145850_b, this.field_174879_c);
            }
            if (ConfigurationHandler.showFog && (!grave.isDecorative() || this.field_145850_b.func_72826_c(0.0f) >= 0.245f && this.field_145850_b.func_72826_c(0.0f) <= 0.755f)) {
                Main.proxy.produceGraveSmoke(this.field_145850_b, this.field_174879_c);
            }
        } else if (this.countTicks % 200 == 0 && !hasSoul && grave.canHoldSoul() && this.field_145850_b.func_72911_I() && (float)Helper.getRandom(1, 1000) <= ConfigurationHandler.chanceGraveSoul) {
            this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)PropertyBool.func_177716_a((String)"has_soul"), (Comparable)Boolean.valueOf(true)), 3);
        }
        ++this.countTicks;
    }

    public <T extends Entity> void setOwner(T owner, long deathDate) {
        this.setOwner(owner.func_145748_c_().func_150260_c(), deathDate);
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerDeathDate(int part, boolean formated) {
        String part2;
        Date date = new Date(this.deathDate);
        String dateString = new SimpleDateFormat("dd/MM/yyyy").format(date);
        String timeString = new SimpleDateFormat("HH:mm:ss").format(date);
        String part1 = formated ? Helper.getTranslation("message.death_date.died_on") + " " + dateString : dateString;
        String string = part2 = formated ? Helper.getTranslation("message.death_date.at") + " " + timeString : timeString;
        return part == 0 ? part1 + " " + part2 : (part == 1 ? part1 : part2);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.countTicks);
        super.func_189515_b(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.ownerName = compound.func_74779_i("ownerName");
        this.deathDate = compound.func_74763_f("deathDate");
        this.countTicks = compound.func_74762_e("countTicks");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

