/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;

public class BlockFacingGrave
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool HAS_SOUL = PropertyBool.func_177716_a((String)"has_soul");
    protected static final AxisAlignedBB ground_bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockFacingGrave(Material materialIn, String name) {
        super(materialIn);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149711_c(4.0f);
        this.func_149752_b(30.0f);
        this.func_149715_a(0.0f);
        this.func_149713_g(255);
        this.setHarvestLevel("shovel", 0);
        this.field_149783_u = true;
        this.func_149647_a(Main.tabTombstone);
        this.field_149762_H = SoundType.field_185851_d;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockFacingGrave.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)ground_bounds);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HAS_SOUL});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)HAS_SOUL) != false ? 8 : 0);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean func_149700_E() {
        return false;
    }

    private AxisAlignedBB getBounds(double voxelX1, double voxelY1, double voxelZ1, double voxelX2, double voxelY2, double voxelZ2, EnumFacing facing) {
        return this.getBounds(new AxisAlignedBB(voxelX1 / 16.0, voxelY1 / 16.0, voxelZ1 / 16.0, voxelX2 / 16.0, voxelY2 / 16.0, voxelZ2 / 16.0), facing);
    }

    private AxisAlignedBB getBounds(AxisAlignedBB shape, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return new AxisAlignedBB(shape.field_72340_a, shape.field_72338_b, 1.0 - shape.field_72334_f, shape.field_72336_d, shape.field_72337_e, 1.0 - shape.field_72339_c);
            }
            case WEST: {
                return new AxisAlignedBB(shape.field_72339_c, shape.field_72338_b, shape.field_72340_a, shape.field_72334_f, shape.field_72337_e, shape.field_72336_d);
            }
            case EAST: {
                return new AxisAlignedBB(1.0 - shape.field_72339_c, shape.field_72338_b, shape.field_72340_a, 1.0 - shape.field_72334_f, shape.field_72337_e, shape.field_72336_d);
            }
        }
        return shape;
    }

    private String showBounds(AxisAlignedBB shape) {
        return "(" + shape.field_72340_a + "d, " + shape.field_72338_b + "d, " + shape.field_72339_c + "d, " + shape.field_72336_d + "d, " + shape.field_72337_e + "d, " + shape.field_72334_f + "d)";
    }

    protected void showAllBounds(double voxelX1, double voxelY1, double voxelZ1, double voxelX2, double voxelY2, double voxelZ2) {
        AxisAlignedBB shape = this.getBounds(voxelX1, voxelY1, voxelZ1, voxelX2, voxelY2, voxelZ2, EnumFacing.NORTH);
        Helper.sendLog("\nNORTH : " + this.showBounds(shape) + "\nSOUTH :" + this.showBounds(this.getBounds(shape, EnumFacing.SOUTH)) + "\nWEST : " + this.showBounds(this.getBounds(shape, EnumFacing.WEST)) + "\nEAST : " + this.showBounds(this.getBounds(shape, EnumFacing.EAST)));
    }
}

