/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ovh.corail.tombstone.block.BlockTileEntityGrave;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.SoundHandler;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class BlockGrave<TE extends TileEntityWritableGrave>
extends BlockTileEntityGrave<TE> {
    public final String name;
    protected final boolean isDecorative;
    protected final GraveType graveType;
    protected final HashMap<EnumFacing, List<AxisAlignedBB>> collisions = new HashMap();

    public BlockGrave(String name, GraveType graveType, boolean isDecorative) {
        super(Material.field_151576_e, name);
        this.name = name;
        this.isDecorative = isDecorative;
        this.graveType = graveType;
        for (EnumFacing facing : FACING.func_177700_c()) {
            this.collisions.put(facing, Lists.newArrayList());
        }
        this.func_149752_b(1.8E7f);
        this.loadCollisions();
        if (!isDecorative) {
            this.func_149647_a(null);
            this.func_149722_s();
            this.func_149715_a(0.5f);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if (!this.isDecorative) {
            return this.field_149782_v;
        }
        boolean isUnbreakable = !world.field_72995_K ? ConfigurationHandler.unbreakableDecorativeGrave : ConfigurationHandler.serverUnbreakableDecorativeGrave;
        return isUnbreakable ? -1.0f : this.field_149782_v;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity == null || entity.field_70170_p == null) {
            return false;
        }
        return !this.isDecorative ? false : !(entity.field_70170_p.field_72995_K ? ConfigurationHandler.serverUnbreakableDecorativeGrave : ConfigurationHandler.unbreakableDecorativeGrave);
    }

    public String func_149739_a() {
        return "tile." + this.name.replace("decorative_", "");
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("pickaxe") || type.equals("shovel");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isDecorative) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGraveMagic)) {
                return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            }
            if (world.field_72995_K) {
                return true;
            }
            ItemGraveMagic item = (ItemGraveMagic)stack.func_77973_b();
            if (!item.isCooldown(world, stack)) {
                if (item.isEnchanted(stack)) {
                    Helper.sendMessage("message.enchant_item.already_enchanted", player, true);
                } else if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue()) {
                    if (item.setEnchant(world, pos, player, stack)) {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)), 3);
                        SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c(), 10.0);
                        Helper.sendMessage(item.getEnchantSuccessMessage(), player, true);
                        Helper.grantAdvancement(player, "tutorial/activate_magic_item");
                        if (Main.grave_key.isStackValid(stack)) {
                            Helper.grantAdvancement(player, "tutorial/upgrade_grave_key");
                        }
                    } else {
                        Helper.sendMessage(item.getEnchantFailedMessage(), player, true);
                    }
                } else {
                    Helper.sendMessage("message.enchant_item.no_soul", player, true);
                }
                item.setCooldown(world, stack, 20);
            }
            return true;
        }
        TileEntityTombstone tile = (TileEntityTombstone)((Object)this.getTileEntity((IBlockAccess)world, pos));
        if (tile == null) {
            return false;
        }
        boolean valid = false;
        if (!tile.getNeedAccess() || player.func_184812_l_()) {
            valid = true;
        } else if (Main.grave_key.isStackValid(player.func_184614_ca())) {
            ItemStack stack = player.func_184614_ca();
            if (Main.grave_key.getTombPos(stack).compareTo((Vec3i)tile.func_174877_v()) == 0 && Main.grave_key.getTombDim(stack) == world.field_73011_w.getDimension()) {
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                valid = true;
            } else {
                Helper.sendMessage("message.open_grave.wrong_key", player, true);
            }
        }
        if (valid) {
            tile.giveInventory(player);
        } else {
            Helper.sendMessage("message.open_grave.need_key", player, true);
        }
        return valid;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean canHoldSoul() {
        return this.isDecorative;
    }

    @Override
    public TE createTileEntity(World world, IBlockState state) {
        return (TE)((Object)(this.isDecorative ? new TileEntityWritableGrave() : new TileEntityTombstone()));
    }

    public GraveType getGraveType() {
        return this.graveType;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        List<AxisAlignedBB> collisionList = this.collisions.get(facing);
        for (AxisAlignedBB collision : collisionList) {
            BlockGrave.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)collision);
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    private void loadCollisions() {
        switch (this.graveType) {
            case GRAVE_CROSS: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.40625, 0.125, 0.6875, 0.59375, 0.9375, 0.875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.40625, 0.125, 0.125, 0.59375, 0.9375, 0.3125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.6875, 0.125, 0.40625, 0.875, 0.9375, 0.59375));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.125, 0.125, 0.40625, 0.3125, 0.9375, 0.59375));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.21875, 0.5625, 0.6875, 0.78125, 0.75, 0.875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.21875, 0.5625, 0.125, 0.78125, 0.75, 0.3125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.6875, 0.5625, 0.21875, 0.875, 0.75, 0.78125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.125, 0.5625, 0.21875, 0.3125, 0.75, 0.78125));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.28125, 0.0625, 0.5625, 0.71875, 0.125, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.28125, 0.0625, 0.0, 0.71875, 0.125, 0.4375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.5625, 0.0625, 0.28125, 1.0, 0.125, 0.71875));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.28125, 0.4375, 0.125, 0.71875));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.34375, 0.125, 0.625, 0.65625, 0.1875, 0.9375));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.34375, 0.125, 0.0625, 0.65625, 0.1875, 0.375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.625, 0.125, 0.34375, 0.9375, 0.1875, 0.65625));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0625, 0.125, 0.34375, 0.375, 0.1875, 0.65625));
                break;
            }
            case GRAVE_NORMAL: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.25, 0.875, 0.8125, 0.875, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.25, 0.0, 0.8125, 0.875, 0.125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.875, 0.25, 0.1875, 1.0, 0.875, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.25, 0.1875, 0.125, 0.875, 0.8125));
                break;
            }
            case GRAVE_SIMPLE: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.0625, 0.8125, 0.8125, 0.875, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.875, 0.1875));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.8125, 0.0625, 0.1875, 1.0, 0.875, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 0.1875, 0.875, 0.8125));
                break;
            }
            default: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.03125, 0.0625, 0.21875, 0.96875, 0.64375, 0.96875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.96875, 0.64375, 0.78125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.21875, 0.0625, 0.03125, 0.96875, 0.64375, 0.96875));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.78125, 0.64375, 0.96875));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.09375, 0.21875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.0625, 0.0625, 0.78125, 0.9375, 0.09375, 0.9375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.21875, 0.09375, 0.9375));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.78125, 0.0625, 0.0625, 0.9375, 0.09375, 0.9375));
            }
        }
    }

    private void addCollision(EnumFacing facing, AxisAlignedBB bounds) {
        List<AxisAlignedBB> listCollisions = this.collisions.get(facing);
        listCollisions.add(bounds);
        this.collisions.put(facing, listCollisions);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList drops = Lists.newArrayList();
        if (!this.isDecorative()) {
            return drops;
        }
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
        Object tile = this.getTileEntity(world, pos);
        if (tile != null && !((TileEntityWritableGrave)((Object)tile)).getOwnerName().isEmpty()) {
            ItemBlockGrave.setEngravedName(stack, ((TileEntityWritableGrave)((Object)tile)).getOwnerName());
        }
        drops.add(stack);
        return drops;
    }

    public static enum GraveType {
        GRAVE_SIMPLE,
        GRAVE_NORMAL,
        GRAVE_CROSS,
        TOMBSTONE;

    }
}

