/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.core;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.UpgradeGraveKeyRecipe;
import ovh.corail.tombstone.handler.AchievementHandler;
import ovh.corail.tombstone.handler.ConfigurationHandler;

public class Helper {
    public static Random random = new Random();

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    public static boolean existClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean grantAdvancement(EntityPlayer player, String name) {
        if (player == null || player.field_70170_p == null) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        AchievementHandler handler = AchievementHandler.getInstance();
        Achievement achievement = handler.getAchievement(name);
        if (achievement == null) {
            return false;
        }
        boolean hasAchievement = player.func_189102_a(achievement);
        if (!hasAchievement) {
            player.func_71064_a((StatBase)achievement, 1);
            String reward = handler.getReward(name);
            if (!reward.isEmpty()) {
                WorldServer world = (WorldServer)player.field_70170_p;
                LootTable loot = world.func_184146_ak().func_186521_a(new ResourceLocation("tombstone", reward));
                LootContext context = new LootContext.Builder(world).func_186471_a();
                List list = loot.func_186462_a(random, context);
                for (ItemStack stack : list) {
                    if (stack.func_190926_b()) continue;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
                }
            }
        }
        return true;
    }

    public static boolean saveAsJson(File file, Set<?> list) {
        if (file.exists()) {
            file.delete();
        }
        try {
            if (file.createNewFile()) {
                FileWriter fw = new FileWriter(file);
                fw.write(new GsonBuilder().setPrettyPrinting().create().toJson(list));
                fw.close();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static <T> HashSet<T> loadAsJson(File file, Class<T> type) {
        Type token = new TypeToken<Set<T>>(){}.getType();
        HashSet list = new HashSet();
        try {
            list = (HashSet)new Gson().fromJson((Reader)new BufferedReader(new FileReader(file)), token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void sendMessage(String message, EntityPlayer player) {
        Helper.sendMessage(message, player, false);
    }

    public static void sendMessage(String message, EntityPlayer player, boolean translate) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            if (translate) {
                message = Helper.getTranslation(message);
            }
            player.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public static String getTranslation(String message) {
        return I18n.func_74838_a((String)message);
    }

    public static String getTranslation(String message, Object ... format) {
        return I18n.func_74837_a((String)message, (Object[])format);
    }

    public static String getTranslationForDimension(int dim) {
        String key;
        switch (dim) {
            case 0: {
                key = "overworld";
                break;
            }
            case -1: {
                key = "nether";
                break;
            }
            case 1: {
                key = "end";
                break;
            }
            default: {
                key = "unknown";
            }
        }
        String translate = Helper.getTranslation("dimension." + key);
        if (dim < -1 || dim > 1) {
            translate = translate + " " + dim;
        }
        return translate;
    }

    public static void sendLog(String message) {
        if (Main.logger != null) {
            Main.logger.log(Level.INFO, message);
        } else {
            System.out.println(message);
        }
    }

    public static void sendMessage(String message, ICommandSender sender, boolean translate) {
        if (!(sender instanceof EntityPlayer)) {
            Helper.sendLog(translate ? Helper.getTranslation(message) : message);
        } else {
            Helper.sendMessage(message, (EntityPlayer)sender, translate);
        }
    }

    public static boolean areItemEqual(ItemStack s1, ItemStack s2) {
        return s1.func_77969_a(s2) && s1.func_77960_j() == s2.func_77960_j() && ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static void setPlayerXp(EntityPlayer player, int experience) {
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
        player.func_71023_q(experience);
    }

    public static ItemStack addToInventoryWithLeftover(ItemStack stack, IInventory inventory, boolean simulate) {
        ItemStack in;
        int i;
        int left = stack.func_190916_E();
        int minus = inventory instanceof InventoryPlayer ? 4 : 0;
        int max = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        for (i = 0; i < inventory.func_70302_i_() - minus; ++i) {
            int space;
            int add;
            in = inventory.func_70301_a(i);
            if (in.func_190926_b() || !stack.func_77969_a(in) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)in) || (add = Math.min(space = max - in.func_190916_E(), stack.func_190916_E())) <= 0) continue;
            if (!simulate) {
                in.func_190917_f(add);
            }
            if ((left -= add) > 0) continue;
            return ItemStack.field_190927_a;
        }
        for (i = 0; i < inventory.func_70302_i_() - minus; ++i) {
            in = inventory.func_70301_a(i);
            if (!in.func_190926_b()) continue;
            int add = Math.min(max, left);
            if (!simulate) {
                inventory.func_70299_a(i, Helper.copyStack(stack, add));
            }
            if ((left -= add) > 0) continue;
            return ItemStack.field_190927_a;
        }
        return Helper.copyStack(stack, left);
    }

    private static ItemStack copyStack(ItemStack stack, int size) {
        if (stack.func_190926_b() || size == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack tmp = stack.func_77946_l();
        tmp.func_190920_e(Math.min(size, stack.func_77976_d()));
        return tmp;
    }

    public static void registerEncodedRecipes() {
        if (ConfigurationHandler.upgradeGraveKey) {
            ItemStack outputKey = new ItemStack((Item)Main.grave_key);
            ArrayList inputList = Lists.newArrayList();
            inputList.add(new ItemStack((Item)Main.grave_key));
            inputList.add(new ItemStack(Items.field_151079_bi));
            RecipeSorter.register((String)"tombstone:upgrade_grave_key", UpgradeGraveKeyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            UpgradeGraveKeyRecipe recipe_upgrade_key = new UpgradeGraveKeyRecipe("", outputKey, inputList);
            GameRegistry.addRecipe((IRecipe)recipe_upgrade_key);
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Main.dark_marble, new Object[]{"stone", "dustGrave"}));
        ItemStack skullStack = new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)Main.decorative_grave_simple, new Object[]{" 0 ", "010", Character.valueOf('0'), Main.dark_marble, Character.valueOf('1'), skullStack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)Main.decorative_grave_cross, new Object[]{" 0 ", "010", " 0 ", Character.valueOf('0'), Main.dark_marble, Character.valueOf('1'), skullStack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)Main.decorative_grave_normal, new Object[]{" 0 ", " 0 ", "010", Character.valueOf('0'), Main.dark_marble, Character.valueOf('1'), skullStack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)Main.decorative_tombstone, new Object[]{"000", "010", Character.valueOf('0'), Main.dark_marble, Character.valueOf('1'), skullStack}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Main.strange_scroll, new Object[]{"101", "202", "101", Character.valueOf('0'), Items.field_151121_aF, Character.valueOf('1'), "stickWood", Character.valueOf('2'), "dustGrave"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(Main.strange_tablet, new Object[]{"01", "10", Character.valueOf('0'), Main.dark_marble, Character.valueOf('1'), "dustGrave"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((Item)Main.scroll_of_knowledge, new Object[]{Main.strange_scroll, "dustGlowstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((Item)Main.scroll_of_preservation, new Object[]{Main.strange_scroll, Items.field_179556_br}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((Item)Main.scroll_of_unstable_intangibleness, new Object[]{Main.strange_scroll, Items.field_151073_bk}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((Item)Main.tablet_of_recall, new Object[]{Main.strange_tablet, new ItemStack(Items.field_151100_aR, 1, 15)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe((Item)Main.tablet_of_assistance, new Object[]{Main.strange_tablet, Items.field_151016_H}));
    }

    public static <T extends EntityLivingBase> void addPotion(T entity, Potion potion, int duration) {
        if (entity == null || potion == null) {
            return;
        }
        entity.func_70690_d(new PotionEffect(potion, duration, 0, true, true));
    }

    public static <T extends EntityLivingBase> boolean isPotionActive(T entity, Potion potion) {
        return Helper.getPotionDuration(entity, potion) > 0;
    }

    public static <T extends EntityLivingBase> int getPotionDuration(T entity, Potion potion) {
        if (entity == null) {
            return 0;
        }
        PotionEffect effect = entity.func_70660_b(potion);
        if (effect == null) {
            return 0;
        }
        if (effect.func_76459_b() > 0) {
            return effect.func_76459_b();
        }
        entity.func_184596_c(potion);
        return 0;
    }
}

