/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import java.util.Date;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.block.BlockFacingGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.handler.DeathHandler;
import ovh.corail.tombstone.handler.PacketHandler;
import ovh.corail.tombstone.handler.SpawnProtectionHandler;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.packet.TombstoneActivatedMessage;
import ovh.corail.tombstone.packet.UpdateServerMessage;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class EventHandler {
    private static DeathHandler deathHandler = DeathHandler.getInstance();

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent event) {
        ItemStack res = event.crafting;
        if (res.func_190926_b()) {
            return;
        }
        if (Main.grave_key.isEnchanted(res)) {
            Helper.grantAdvancement(event.player, "tutorial/upgrade_grave_key");
        } else if (res.func_77973_b() == Item.func_150898_a((Block)Main.dark_marble)) {
            Helper.grantAdvancement(event.player, "tutorial/create_dark_marble");
        } else if (res.func_77973_b() instanceof ItemBlockGrave) {
            Helper.grantAdvancement(event.player, "tutorial/create_decorative_grave");
        } else if (res.func_77973_b() == Main.strange_scroll) {
            Helper.grantAdvancement(event.player, "tutorial/create_strange_scroll");
        } else if (res.func_77973_b() == Main.strange_tablet) {
            Helper.grantAdvancement(event.player, "tutorial/create_strange_tablet");
        } else if (res.func_77973_b() instanceof ItemScroll) {
            Helper.grantAdvancement(event.player, "tutorial/create_magic_scroll");
        } else if (res.func_77973_b() instanceof ItemTablet) {
            Helper.grantAdvancement(event.player, "tutorial/create_magic_tablet");
        }
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        ItemStack res = event.getItem().func_92059_d();
        if (res.func_190926_b()) {
            return;
        }
        if (res.func_77973_b().equals(Main.grave_dust)) {
            Helper.grantAdvancement(event.getEntityPlayer(), "tutorial/find_grave_dust");
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tombstone")) {
            ConfigurationHandler.refreshConfig();
            if (!ConfigurationHandler.lastFavoriteGrave.equals(ConfigurationHandler.favoriteGrave)) {
                ConfigurationHandler.lastFavoriteGrave = ConfigurationHandler.favoriteGrave;
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerMessage(ConfigurationHandler.favoriteGrave, false));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLogued(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getWorld().field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerMessage(ConfigurationHandler.favoriteGrave, true));
            } else {
                Helper.grantAdvancement(player, "tutorial/tutorial");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (Helper.isPotionActive(entity, Main.potionUnstableIntangibleness) && entity.func_70660_b(Main.potionUnstableIntangibleness).func_76459_b() % 100 > 79) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttackGhost(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        EntityLivingBase attacker = event.getEntityLiving();
        EntityLivingBase target = event.getTarget();
        if (Helper.isPotionActive(target, Main.potionGhostlyShape)) {
            ((EntityLiving)attacker).func_70624_b(null);
            attacker.func_70604_c(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (Helper.isPotionActive(player, Main.potionGhostlyShape)) {
            player.func_184596_c(Main.potionGhostlyShape);
            Helper.grantAdvancement(player, "tutorial/cancel_ghostly_shape");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        deathHandler.restorePlayerDeadNIC(event.player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            if (!event.isCanceled()) {
                deathHandler.handleMobDrops(event.getEntityLiving(), event.getDrops());
            }
            return;
        }
        if (!ConfigurationHandler.handlePlayerDeath) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory") || player.func_184812_l_()) {
            return;
        }
        this.buildTombstone(event, player);
        Helper.grantAdvancement(player, "tutorial/first_grave");
        if (CompatibilityGraveStone.getInstance().isEuhDawson()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void give(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayer original = event.getOriginal();
        if (!event.isWasDeath() || player.func_184812_l_()) {
            return;
        }
        deathHandler.addPlayerDeadNIC(original);
        int restoredXp = Helper.isPotionActive(player, Main.potionPreservation) ? original.field_71067_cb : (int)Math.floor(original.field_71067_cb * (100 - ConfigurationHandler.xpLoss) / 100);
        Helper.setPlayerXp(player, restoredXp);
        if (!ConfigurationHandler.handlePlayerDeath || player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        for (int i = 0; i < original.field_71071_by.func_70302_i_(); ++i) {
            ItemStack originalStack = original.field_71071_by.func_70301_a(i);
            ItemStack playerStack = player.field_71071_by.func_70301_a(i);
            if (!Main.grave_key.isStackValid(originalStack) || Main.grave_key.isStackValid(playerStack)) continue;
            player.field_71071_by.func_70299_a(i, originalStack.func_77946_l());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            event.setCanceled(true);
        }
    }

    private void buildTombstone(LivingDropsEvent event, EntityPlayer player) {
        ItemStack stack;
        Entity killer;
        World world = player.field_70170_p;
        BlockPos currentPos = deathHandler.getSafePos(world, player.func_180425_c(), ConfigurationHandler.graveRange);
        if (currentPos == null) {
            Helper.sendLog("No way to find a place for the grave.");
            return;
        }
        double range = ConfigurationHandler.snifferRange;
        List itemList = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)currentPos.func_177958_n() - range, (double)currentPos.func_177956_o() - range, (double)currentPos.func_177952_p() - range, (double)currentPos.func_177958_n() + range, (double)currentPos.func_177956_o() + range, (double)currentPos.func_177952_p() + range));
        if (itemList.size() < 1 && event.getDrops().size() < 1) {
            return;
        }
        deathHandler.logLastGrave(player, currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p(), world.field_73011_w.getDimension());
        EnumFacing facing = event.getEntityLiving().func_174811_aO().func_176734_d();
        Block graveType = deathHandler.getFavoriteGraveBlock(player.func_110124_au());
        IBlockState state = graveType.func_176223_P().func_177226_a((IProperty)BlockFacingGrave.FACING, (Comparable)facing);
        world.func_175656_a(currentPos, state);
        TileEntityTombstone tile = (TileEntityTombstone)world.func_175625_s(currentPos);
        boolean needAccess = ConfigurationHandler.playerGraveAccess;
        if (needAccess && ConfigurationHandler.pvpMode && event.getSource() != null && (killer = event.getSource().func_76346_g()) != null && killer instanceof EntityPlayer) {
            needAccess = false;
        }
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        tile.setOwner(player, new Date().getTime(), needAccess);
        for (EntityItem drop : event.getDrops()) {
            stack = drop.func_92059_d();
            if (stack.func_190926_b()) continue;
            if (!Main.grave_key.isStackValid(stack)) {
                ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                continue;
            }
            Helper.addToInventoryWithLeftover(stack, (IInventory)player.field_71071_by, false);
        }
        event.getDrops().clear();
        for (EntityItem entityItem : itemList) {
            stack = entityItem.func_92059_d();
            if (stack.func_190926_b()) continue;
            ItemStack leftOver = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (leftOver.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            entityItem.func_92058_a(leftOver);
        }
        if (ConfigurationHandler.playerGraveAccess || ConfigurationHandler.graveKeyOnDeath) {
            ItemStack key = new ItemStack((Item)Main.grave_key, 1, 0);
            Main.grave_key.setTombPos(key, currentPos, world.field_73011_w.getDimension());
            Helper.addToInventoryWithLeftover(key, (IInventory)player.field_71071_by, false);
        }
        world.func_184138_a(currentPos, state, state, 2);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        Item ingredient;
        Item item = ingredient = event.getRight().func_190926_b() ? null : event.getRight().func_77973_b();
        if (ItemBlockGrave.isStackValid(event.getLeft()) && ingredient == Items.field_151042_j) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ItemBlockGrave.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                event.setCost(0);
                event.setOutput(ItemStack.field_190927_a);
                event.setMaterialCost(0);
            }
        } else if (Main.tablet_of_assistance.isEnchanted(event.getLeft()) && ingredient == Main.grave_dust) {
            ItemStack output = event.getLeft().func_77946_l();
            if (Main.tablet_of_assistance.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                event.setCost(0);
                event.setOutput(ItemStack.field_190927_a);
                event.setMaterialCost(0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAnvilRepair(AnvilRepairEvent event) {
        Item ingredient;
        Item item = ingredient = event.getIngredientInput().func_190926_b() ? null : event.getIngredientInput().func_77973_b();
        if (ItemBlockGrave.isStackValid(event.getItemInput()) && ingredient == Items.field_151042_j && ItemBlockGrave.isEngraved(event.getItemResult())) {
            Helper.grantAdvancement(event.getEntityPlayer(), "tutorial/engrave_decorative_grave");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void uncancelGraveRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block instanceof BlockGrave && !((BlockGrave)block).isDecorative()) {
            SpawnProtectionHandler handler;
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().field_72995_K && (handler = SpawnProtectionHandler.getInstance()).isBlockProtected(event.getWorld().field_73011_w.getDimension(), event.getPos())) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void uncancelGraveBuild(BlockEvent.PlaceEvent event) {
        Block block;
        if (event.isCanceled() && (block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) instanceof BlockGrave && !((BlockGrave)block).isDecorative()) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDropsStart(LivingDropsEvent event) {
        if (ConfigurationHandler.handlePlayerDeath && CompatibilityGraveStone.getInstance().isEuhDawson()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLivingDropsEnd(LivingDropsEvent event) {
        if (ConfigurationHandler.handlePlayerDeath && CompatibilityGraveStone.getInstance().isEuhDawson()) {
            event.setCanceled(false);
        }
    }
}

