/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.handler;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.core.Main;

@Mod.EventBusSubscriber
public class RegistryHandler {
    private static BlockGrave[] graves = new BlockGrave[]{Main.decorative_grave_simple, Main.decorative_grave_normal, Main.decorative_grave_cross, Main.decorative_tombstone, Main.grave_simple, Main.grave_normal, Main.grave_cross, Main.tombstone};
    private static Block[] blocks = new Block[]{Main.dark_marble};
    private static Item[] items = new Item[]{Main.grave_key, Main.fake_fog, Main.soul, Main.grave_dust, Main.strange_scroll, Main.strange_tablet, Main.scroll_of_knowledge, Main.scroll_of_preservation, Main.scroll_of_unstable_intangibleness, Main.tablet_of_recall, Main.tablet_of_assistance, Main.advancement_001, Main.advancement_002, Main.advancement_003, Main.advancement_004, Main.advancement_005, Main.advancement_006};

    public <T extends BlockGrave> void addGrave(T grave) {
        RegistryHandler.graves[RegistryHandler.graves.length] = grave;
    }

    public void addItem(Item item) {
        RegistryHandler.items[RegistryHandler.items.length] = item;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry blocksRegistry = event.getRegistry();
        blocksRegistry.registerAll((IForgeRegistryEntry[])graves);
        blocksRegistry.registerAll((IForgeRegistryEntry[])blocks);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ItemBlockGrave itemBlock;
        IForgeRegistry itemsRegistry = event.getRegistry();
        boolean isClientSide = Main.proxy.getSide() == Side.CLIENT;
        for (BlockGrave blockGrave : graves) {
            if (!blockGrave.isDecorative()) continue;
            itemBlock = new ItemBlockGrave(blockGrave);
            itemsRegistry.register(itemBlock.setRegistryName(blockGrave.getRegistryName()));
            if (!isClientSide) continue;
            itemBlock.initModel();
        }
        for (BlockGrave blockGrave : blocks) {
            itemBlock = (Item)new ItemBlock((Block)blockGrave).setRegistryName(blockGrave.getRegistryName());
            itemsRegistry.register((IForgeRegistryEntry)itemBlock);
            if (!isClientSide) continue;
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemBlock.getRegistryName(), "inventory"));
        }
        itemsRegistry.registerAll((IForgeRegistryEntry[])items);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void renderItems(ModelRegistryEvent event) {
        for (Item item : items) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)Main.potionGhostlyShape);
        registry.register((IForgeRegistryEntry)Main.potionPreservation);
        registry.register((IForgeRegistryEntry)Main.potionUnstableIntangibleness);
    }
}

