/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class ItemGraveKey
extends ItemGraveMagic {
    public ItemGraveKey() {
        super("grave_key");
        this.func_77637_a(null);
    }

    public String func_77653_i(ItemStack stack) {
        String normalName = Helper.getTranslation("item.grave_key.name");
        return this.isEnchanted(stack) ? Helper.getTranslation("item.grave_key.upgraded_name", normalName) : normalName;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        int id = this.isEnchanted(stack) ? 2 : 1;
        this.addItemDesc(list, id, new Object[0]);
        BlockPos tombPos = this.getTombPos(stack);
        int tombDimId = this.getTombDim(stack);
        if (this.isValidTombPos(tombPos, tombDimId)) {
            String tombDim = Helper.getTranslationForDimension(tombDimId);
            list.add(TextFormatting.WHITE + Helper.getTranslation("message.grave_pos") + " : " + tombDim + " (" + tombPos.func_177958_n() + ", " + tombPos.func_177956_o() + ", " + tombPos.func_177952_p() + ")");
            this.addItemUse(list, id, new Object[0]);
        }
    }

    private boolean isValidTombPos(BlockPos pos, int dim) {
        return pos != BlockPos.field_177992_a && dim != Integer.MIN_VALUE;
    }

    public boolean setTombPos(ItemStack stack, BlockPos tombPos, int tombDim) {
        if (!this.isStackValid(stack) || !this.isValidTombPos(tombPos, tombDim)) {
            return false;
        }
        NBTStackHelper.setBlockPos(stack, "tombPos", tombPos);
        NBTStackHelper.setInteger(stack, "tombDim", tombDim);
        return true;
    }

    public BlockPos getTombPos(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return BlockPos.field_177992_a;
        }
        return NBTStackHelper.getBlockPos(stack, "tombPos");
    }

    public int getTombDim(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return Integer.MIN_VALUE;
        }
        return NBTStackHelper.getInteger(stack, "tombDim");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (world.field_72995_K || !this.isStackValid(stack)) {
            return;
        }
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int tombDimId = this.getTombDim(stack);
        if (tombDimId != world.field_73011_w.getDimension()) {
            return;
        }
        BlockPos tombPos = this.getTombPos(stack);
        if (!world.func_175667_e(tombPos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(tombPos);
        if (tile == null || !(tile instanceof TileEntityTombstone)) {
            player.func_174820_d(slotId, ItemStack.field_190927_a);
            player.field_71069_bz.func_75142_b();
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!this.isStackValid(stack) || !ConfigurationHandler.upgradeGraveKey) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    public String getEnchantFailedMessage() {
        return "message.enchant_item.cant_update_grave_key";
    }

    @Override
    protected boolean doEffects(World world, EntityPlayer player, ItemStack stack) {
        int tombDim;
        BlockPos tombPos = this.getTombPos(stack);
        if (!this.isValidTombPos(tombPos, tombDim = this.getTombDim(stack))) {
            Helper.sendMessage("message.teleport.failed", player, true);
            return false;
        }
        if (player.field_71093_bK != tombDim && !ConfigurationHandler.teleportDim) {
            Helper.sendMessage("message.teleport.sameDimension", player, true);
            return false;
        }
        stack.func_77978_p().func_74757_a("enchant", false);
        TeleportUtils.teleportEntity((Entity)player, tombDim, (double)tombPos.func_177958_n() + 0.5, (double)tombPos.func_177956_o() + 1.05, (double)tombPos.func_177952_p() + 0.5);
        Helper.grantAdvancement(player, "tutorial/teleport_to_grave");
        Helper.sendMessage("message.teleport.success", player, true);
        return true;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }
}

