/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.Main;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.item.ItemTablet;

public class ItemTabletOfAssistance
extends ItemTablet {
    public ItemTabletOfAssistance() {
        super("tablet_of_assistance");
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        if (!this.isEnchanted(stack)) {
            this.addItemDesc(list, 1, new Object[0]);
            this.addItemUse(list, 1, new Object[0]);
        } else {
            String engraved_name = this.getEngravedName(stack);
            if (engraved_name.isEmpty()) {
                this.addItemDesc(list, 1, new Object[0]);
                this.addItemUse(list, 2, TextFormatting.YELLOW + "[" + Helper.getTranslation(Main.grave_dust.func_77658_a() + ".name").toLowerCase() + "]");
            } else {
                list.add(TextFormatting.GRAY + "\u00a7o" + Helper.getTranslation("message.engraved") + "\"" + engraved_name + "\"");
                this.addItemUse(list, 3, new Object[0]);
            }
        }
        super.func_77624_a(stack, player, list, flag);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        return true;
    }

    public boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (!this.isEnchanted(stack) || engraved_name.isEmpty()) {
            return false;
        }
        NBTStackHelper.setString(stack, "engraved_name", engraved_name);
        return true;
    }

    public boolean isEngraved(ItemStack stack) {
        return this.isEnchanted(stack) && !this.getEngravedName(stack).isEmpty();
    }

    public String getEngravedName(ItemStack stack) {
        if (!this.isEnchanted(stack)) {
            return "";
        }
        return NBTStackHelper.getString(stack, "engraved_name");
    }

    @Override
    protected boolean doEffects(World world, EntityPlayer player, ItemStack stack) {
        String engraved_name = NBTStackHelper.getString(stack, "engraved_name");
        if (engraved_name.equals(player.func_70005_c_())) {
            Helper.sendMessage("message.teleport.failed", player, true);
            return false;
        }
        EntityPlayerMP target = world.func_73046_m().func_184103_al().func_152612_a(engraved_name);
        if (target == null) {
            Helper.sendMessage("message.teleport.failed", player, true);
            return false;
        }
        if (target.field_71093_bK != player.field_71093_bK && !ConfigurationHandler.teleportDim) {
            Helper.sendMessage("message.teleport.sameDimension", player, true);
            return false;
        }
        TeleportUtils.teleportEntity((Entity)player, target.field_71093_bK, target.field_70165_t + 0.5, target.field_70163_u + 1.05, target.field_70161_v + 0.5);
        Helper.sendMessage("message.teleport.success", player, true);
        Helper.grantAdvancement(player, "tutorial/use_assistance");
        return true;
    }
}

