/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.core.Helper;
import ovh.corail.tombstone.core.NBTStackHelper;
import ovh.corail.tombstone.core.TeleportUtils;
import ovh.corail.tombstone.handler.ConfigurationHandler;
import ovh.corail.tombstone.item.ItemTablet;

public class ItemTabletOfRecall
extends ItemTablet {
    public ItemTabletOfRecall() {
        super("tablet_of_recall");
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        this.addItemDesc(list, 1, new Object[0]);
        if (!this.isEnchanted(stack)) {
            this.addItemUse(list, 1, new Object[0]);
        } else {
            int tombDimId;
            BlockPos tombPos = this.getTombPos(stack);
            if (this.isValidTombPos(tombPos, tombDimId = this.getTombDim(stack))) {
                String tombDim = Helper.getTranslationForDimension(tombDimId);
                list.add(TextFormatting.WHITE + Helper.getTranslation("message.grave_pos") + " : " + tombDim + " (" + tombPos.func_177958_n() + ", " + tombPos.func_177956_o() + ", " + tombPos.func_177952_p() + ")");
                this.addItemUse(list, 2, new Object[0]);
            }
        }
        super.func_77624_a(stack, player, list, flag);
    }

    private boolean isValidTombPos(BlockPos pos, int dim) {
        return pos != BlockPos.field_177992_a && dim != Integer.MIN_VALUE;
    }

    public boolean setTombPos(ItemStack stack, BlockPos tombPos, int tombDim) {
        if (!this.isStackValid(stack) || !this.isValidTombPos(tombPos, tombDim)) {
            return false;
        }
        NBTStackHelper.setBlockPos(stack, "tombPos", tombPos);
        NBTStackHelper.setInteger(stack, "tombDim", tombDim);
        return true;
    }

    public BlockPos getTombPos(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return BlockPos.field_177992_a;
        }
        return NBTStackHelper.getBlockPos(stack, "tombPos");
    }

    public int getTombDim(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return Integer.MIN_VALUE;
        }
        return NBTStackHelper.getInteger(stack, "tombDim");
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        if (!this.isStackValid(stack)) {
            return false;
        }
        return this.isValidTombPos(this.getTombPos(stack), this.getTombDim(stack));
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        boolean valid = this.setTombPos(stack, gravePos, world.field_73011_w.getDimension());
        if (valid) {
            this.setUseCount(stack, this.getUseMax());
        }
        return valid;
    }

    @Override
    public String getEnchantSuccessMessage() {
        return "message.bind_grave";
    }

    @Override
    protected boolean doEffects(World world, EntityPlayer player, ItemStack stack) {
        BlockPos tombPos = this.getTombPos(stack);
        int tombDim = this.getTombDim(stack);
        if (world.field_73011_w.getDimension() == tombDim && tombPos.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 10.0) {
            Helper.sendMessage("message.teleport.too_close_from_grave", player, true);
            return false;
        }
        if (player.field_71093_bK != tombDim && !ConfigurationHandler.teleportDim) {
            Helper.sendMessage("message.teleport.sameDimension", player, true);
            return false;
        }
        TeleportUtils.teleportEntity((Entity)player, tombDim, (double)tombPos.func_177958_n() + 0.5, (double)tombPos.func_177956_o() + 1.05, (double)tombPos.func_177952_p() + 0.5);
        Helper.sendMessage("message.teleport.success", player, true);
        Helper.grantAdvancement(player, "tutorial/use_recall");
        return true;
    }
}

