/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.mojang.brigadier.CommandDispatcher;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.command.CommandTBKnownledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.CommandTBTeleportDiscovery;
import ovh.corail.tombstone.command.CommandTBTeleportGrave;
import ovh.corail.tombstone.command.CommandTBTeleportVillage;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.WorldFunctionInjector;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.recipe.RecipeEnchantedGraveKey;
import ovh.corail.tombstone.recipe.RecipeVoodooPoppetProtection;

@Mod(value="tombstone")
public class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final EnumEnchantmentType TYPE_TOMBSTONE_ALL = EnumEnchantmentType.create((String)"TYPE_TOMBSTONE_ALL", p -> p != null && (p.func_77619_b() > 0 || p.func_77639_j() == 1));
    public static final EnumEnchantmentType TYPE_TOMBSTONE_FEET = EnumEnchantmentType.create((String)"TYPE_TOMBSTONE_FEET", arg_0 -> ((EnumEnchantmentType)EnumEnchantmentType.ARMOR_FEET).func_77557_a(arg_0));
    private static final URL CONTRIBUTORS;

    public ModTombstone() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigTombstone.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigTombstone.GENERAL_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void preInit(FMLCommonSetupEvent event) {
        PacketHandler.init();
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)WorldFunctionInjector.builder().put(new ResourceLocation(MOD_ID, "knowledge"), (sender, params) -> {
            Entity entity = sender.func_197022_f();
            if (entity instanceof EntityPlayerMP) {
                EntityHelper.addKnowledge((EntityPlayerMP)entity, params.getInt("amount", 1));
            }
        }).build());
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        RecipeSerializers.func_199573_a((IRecipeSerializer)new RecipeSerializers.SimpleSerializer("tombstone:enchanted_grave_key", RecipeEnchantedGraveKey::new));
        RecipeSerializers.func_199573_a((IRecipeSerializer)new RecipeSerializers.SimpleSerializer("tombstone:voodoo_poppet_protection", RecipeVoodooPoppetProtection::new));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        if (((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue() && SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        new CommandTBRestoreInventory((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBShowLastGrave((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleportGrave((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBKnownledge((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBRequestTeleport((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBSiege((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleportVillage((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleportDiscovery((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBRecovery((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        new CommandTBTeleport((CommandDispatcher<CommandSource>)event.getCommandDispatcher()).registerCommand();
        MinecraftForge.EVENT_BUS.register((Object)new CallbackHandler());
        Futures.addCallback(ContributorStore.read(CONTRIBUTORS, event.getServer().field_110456_c), (FutureCallback)new FutureCallback<ContributorStore>(){

            public void onSuccess(@Nullable ContributorStore result) {
                Helper.CONTRIBUTORS = result;
            }

            @ParametersAreNonnullByDefault
            public void onFailure(Throwable t) {
                LOGGER.info("The list of contributors and patreons couldn't be loaded");
            }
        });
    }

    @SubscribeEvent
    public void onServerStoppingEvent(FMLServerStoppedEvent event) {
        CallbackHandler.clear();
        DeathHandler.instance.clear();
    }

    static {
        try {
            CONTRIBUTORS = new URL("https://raw.githubusercontent.com/Corail31/trash/master/contributors.json");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

