/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ISoulConsumer;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class BlockDecorativeGrave
extends BlockGraveBase<TileEntityDecorativeGrave> {
    public static final BooleanProperty HAS_SOUL = BooleanProperty.func_177716_a((String)"has_soul");

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder(), graveModel);
        this.func_180632_j((IBlockState)this.func_176223_P().func_206870_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Class<TileEntityDecorativeGrave> getTileEntityClass() {
        return TileEntityDecorativeGrave.class;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{HAS_SOUL});
    }

    @Nullable
    public ToolType getHarvestTool(IBlockState state) {
        return ToolType.PICKAXE;
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    public float func_176195_g(IBlockState state, IBlockReader world, BlockPos pos) {
        return ConfigTombstone.decorative_grave.isUnbreakableDecorativeGrave() ? -1.0f : this.field_149782_v;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return !ConfigTombstone.decorative_grave.isUnbreakableDecorativeGrave();
    }

    public boolean isToolEffective(IBlockState state, ToolType type) {
        return type == ToolType.PICKAXE || type == ToolType.SHOVEL;
    }

    public boolean canHarvestBlock(IBlockState state, IBlockReader world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSpade) && !(stack.func_77973_b() instanceof ItemPickaxe)) {
            return super.canHarvestBlock(state, world, pos, player);
        }
        return true;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND || playerIn.func_184614_ca().func_190926_b()) {
            return false;
        }
        ItemStack stack = playerIn.func_184614_ca();
        if (world.field_72995_K) {
            return !EntityHelper.hasCooldown(playerIn, stack);
        }
        EntityPlayerMP player = (EntityPlayerMP)playerIn;
        if (!(stack.func_77973_b() instanceof ISoulConsumer) && stack.func_77973_b() != ModItems.soul_receptacle) {
            return super.func_196250_a(state, world, pos, (EntityPlayer)player, hand, facing, hitX, hitY, hitZ);
        }
        if (!EntityHelper.hasCooldown((EntityPlayer)player, stack)) {
            if (stack.func_77973_b() == ModItems.soul_receptacle) {
                EntityHelper.setCooldown((EntityPlayer)player, stack, 10);
                if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue()) {
                    player.func_145747_a(LangKey.MESSAGE_FREESOUL_FAILED.getTranslation());
                    return super.func_196250_a(state, world, pos, (EntityPlayer)player, hand, facing, hitX, hitY, hitZ);
                }
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
                player.func_145747_a(LangKey.MESSAGE_FREESOUL_SUCCESS.getTranslation());
                if (!player.func_184812_l_()) {
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
                EntityHelper.addKnowledge(player, 10L);
                return true;
            }
            ISoulConsumer itemConsumer = (ISoulConsumer)stack.func_77973_b();
            if (itemConsumer.isEnchanted(stack)) {
                player.func_145747_a(LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getTranslation());
            } else if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue()) {
                if (itemConsumer.canEnchant(world, pos, (EntityPlayer)player, stack)) {
                    if (itemConsumer.setEnchant(world, pos, (EntityPlayer)player, stack)) {
                        world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)), 3);
                        TileEntityDecorativeGrave tile = (TileEntityDecorativeGrave)((Object)this.getTileEntity(world, pos));
                        if (tile != null) {
                            tile.resetCheckSoul();
                        }
                        ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundCategory.PLAYERS, world, player.func_180425_c(), 0.5f, 0.5f);
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(itemConsumer.getEnchantSuccessMessage(), new Object[0]));
                        Helper.grantAdvancement((EntityPlayer)player, "adventure/activate_magic_item", new String[0]);
                        EntityHelper.addKnowledge(player, itemConsumer.getKnowledge());
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation(itemConsumer.getEnchantFailedMessage(), new Object[0]));
                    }
                } else {
                    player.func_145747_a(LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.getTranslation());
                }
            } else {
                player.func_145747_a(LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.getTranslation());
            }
            EntityHelper.setCooldown((EntityPlayer)player, stack, 10);
        }
        return true;
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entity) {
        ItemStack stack;
        if (!world.field_72995_K && entity.func_70093_af() && !entity.field_70128_L && TimeHelper.atInterval(entity.field_70173_aa, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((EntityPlayer)entity).func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ISoulConsumer) {
            ((ISoulConsumer)stack.func_77973_b()).onSneakGrave(world, pos, (EntityPlayer)entity, stack);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        TileEntityDecorativeGrave tile = (TileEntityDecorativeGrave)((Object)this.getTileEntity(world, pos));
        if (tile != null && !tile.getOwnerName().isEmpty()) {
            ItemBlockGrave.setEngravedName(stack, tile.getOwnerName());
        }
        drops.add((Object)stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        Helper.removeNoEvent(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, @Nullable EntityLivingBase placer, ItemStack stack) {
        TileEntityDecorativeGrave tile;
        String engraved_name;
        if (!world.field_72995_K && !(engraved_name = NBTStackHelper.getString(stack, "engraved_name")).isEmpty() && (tile = (TileEntityDecorativeGrave)((Object)this.getTileEntity(world, pos))) != null) {
            tile.setOwner(engraved_name, new Date().getTime());
        }
    }

    private static Block.Properties getBuilder() {
        return Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 1.8E7f).func_200951_a(3).func_200947_a(SoundType.field_185851_d);
    }
}

