/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public abstract class BlockGraveBase<T extends TileEntityWritableGrave>
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty FACING = BlockHorizontal.field_185512_D;
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.func_177716_a((String)"is_engraved");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected final GraveModel graveModel;
    public static final EnumFacing[] rotations = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};

    public BlockGraveBase(Block.Properties builder, GraveModel graveModel) {
        super(builder);
        this.graveModel = graveModel;
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)IS_ENGRAVED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149739_a() {
        return "tombstone.grave." + this.graveModel.func_176610_l();
    }

    public void onBlockExploded(IBlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public void func_196243_a(IBlockState oldState, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(oldState, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IBlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        return (IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(state.func_177230_c() != this && context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a))).func_206870_a((IProperty)IS_ENGRAVED, (Comparable)Boolean.valueOf(ItemBlockGrave.isEngraved(context.func_195996_i())));
    }

    public int func_196264_a(IBlockState state, Random random) {
        return 0;
    }

    public boolean func_149700_E() {
        return false;
    }

    protected abstract Class<T> getTileEntityClass();

    @Nullable
    protected T getTileEntity(World world, BlockPos pos) {
        return (T)((Object)((TileEntityWritableGrave)world.func_175625_s(pos)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public T createTileEntity(IBlockState state, IBlockReader world) {
        TileEntityWritableGrave newInstance = null;
        try {
            newInstance = (TileEntityWritableGrave)((Object)this.getTileEntityClass().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return (T)((Object)newInstance);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, IS_ENGRAVED, WATERLOGGED});
    }

    public IBlockState func_196271_a(IBlockState olState, EnumFacing facing, IBlockState newState, IWorld world, BlockPos oldPos, BlockPos newPos) {
        if (((Boolean)olState.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(oldPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)world));
        }
        return super.func_196271_a(olState, facing, newState, world, oldPos, newPos);
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, IBlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, IBlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReaderBase)world));
            }
            return true;
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.graveModel.getShape((EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    public GraveModel getGraveType() {
        return this.graveModel;
    }

    @Nullable
    public EnumFacing[] getValidRotations(IBlockState state, IBlockReader world, BlockPos pos) {
        return rotations;
    }
}

