/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public enum GraveModel implements IStringSerializable
{
    GRAVE_SIMPLE("grave_simple"),
    GRAVE_NORMAL("grave_normal"),
    GRAVE_CROSS("grave_cross"),
    TOMBSTONE("tombstone");

    private final String name;
    private final Map<EnumFacing, VoxelShape> collisions = new HashMap<EnumFacing, VoxelShape>();
    private static final AxisAlignedBB ground_bounds;

    private GraveModel(String name) {
        this.name = name;
    }

    public final VoxelShape getShape(EnumFacing facing) {
        return this.collisions.get(facing);
    }

    public static GraveModel getModel(int id) {
        return id >= 0 && id < GraveModel.values().length ? GraveModel.values()[id] : GraveModel.getDefaultGrave();
    }

    public static GraveModel getDefaultGrave() {
        return GRAVE_SIMPLE;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    private void createShape() {
        switch (this.name) {
            case "grave_normal": {
                this.collisions.put(EnumFacing.NORTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.25, 0.875, 0.8125, 0.875, 1.0))));
                this.collisions.put(EnumFacing.SOUTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.25, 0.0, 0.8125, 0.875, 0.125))));
                this.collisions.put(EnumFacing.WEST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.875, 0.25, 0.1875, 1.0, 0.875, 0.8125))));
                this.collisions.put(EnumFacing.EAST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.25, 0.1875, 0.125, 0.875, 0.8125))));
                break;
            }
            case "grave_cross": {
                this.collisions.put(EnumFacing.NORTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.40625, 0.125, 0.6875, 0.59375, 0.9375, 0.875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.21875, 0.5625, 0.6875, 0.78125, 0.75, 0.875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.28125, 0.0625, 0.5625, 0.71875, 0.125, 1.0))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.34375, 0.125, 0.625, 0.65625, 0.1875, 0.9375))));
                this.collisions.put(EnumFacing.SOUTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.40625, 0.125, 0.125, 0.59375, 0.9375, 0.3125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.21875, 0.5625, 0.125, 0.78125, 0.75, 0.3125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.28125, 0.0625, 0.0, 0.71875, 0.125, 0.4375))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.34375, 0.125, 0.0625, 0.65625, 0.1875, 0.375))));
                this.collisions.put(EnumFacing.WEST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.6875, 0.125, 0.40625, 0.875, 0.9375, 0.59375))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.6875, 0.5625, 0.21875, 0.875, 0.75, 0.78125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.5625, 0.0625, 0.28125, 1.0, 0.125, 0.71875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.625, 0.125, 0.34375, 0.9375, 0.1875, 0.65625))));
                this.collisions.put(EnumFacing.EAST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.125, 0.125, 0.40625, 0.3125, 0.9375, 0.59375))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.125, 0.5625, 0.21875, 0.3125, 0.75, 0.78125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0625, 0.28125, 0.4375, 0.125, 0.71875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.125, 0.34375, 0.375, 0.1875, 0.65625))));
                break;
            }
            case "tombstone": {
                this.collisions.put(EnumFacing.NORTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.03125, 0.0625, 0.21875, 0.96875, 0.64375, 0.96875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.09375, 0.21875))));
                this.collisions.put(EnumFacing.SOUTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.96875, 0.64375, 0.78125))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0625, 0.78125, 0.9375, 0.09375, 0.9375))));
                this.collisions.put(EnumFacing.WEST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.21875, 0.0625, 0.03125, 0.96875, 0.64375, 0.96875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.21875, 0.09375, 0.9375))));
                this.collisions.put(EnumFacing.EAST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.78125, 0.64375, 0.96875))), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.78125, 0.0625, 0.0625, 0.9375, 0.09375, 0.9375))));
                break;
            }
            default: {
                this.collisions.put(EnumFacing.NORTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0625, 0.8125, 0.8125, 0.875, 1.0))));
                this.collisions.put(EnumFacing.SOUTH, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.875, 0.1875))));
                this.collisions.put(EnumFacing.WEST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.8125, 0.0625, 0.1875, 1.0, 0.875, 0.8125))));
                this.collisions.put(EnumFacing.EAST, VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)ground_bounds), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0625, 0.1875, 0.1875, 0.875, 0.8125))));
            }
        }
    }

    static {
        ground_bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        for (GraveModel model : GraveModel.values()) {
            model.createShape();
        }
    }
}

