/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModTabs;

public class ItemBlockGrave
extends ItemBlock {
    public ItemBlockGrave(Block grave) {
        super(grave, new Item.Properties().func_200916_a(ModTabs.mainTab).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        String engravedName = ItemBlockGrave.getEngravedName(stack);
        if (engravedName.isEmpty()) {
            tooltip.add(LangKey.MESSAGE_ENGRAVABLE.getTranslationWithStyle(StyleType.TOOLTIP_DESC, new TextComponentString("[" + I18n.func_135052_a((String)Items.field_151042_j.func_77658_a(), (Object[])new Object[0]) + "]").func_150255_a(StyleType.TOOLTIP_ITEM.getStyle())));
        } else {
            tooltip.add(LangKey.MESSAGE_ENGRAVED.getTranslationWithStyle(StyleType.TOOLTIP_DESC, new TextComponentString("\"" + engravedName + "\"").func_150255_a(StyleType.TOOLTIP_ITEM.getStyle())));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        TextComponentTranslation baseTranslation = new TextComponentTranslation(this.func_77658_a(), new Object[0]);
        return ItemBlockGrave.getEngravedName(stack).isEmpty() ? baseTranslation : LangKey.MESSAGE_ENGRAVED_ITEM.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, baseTranslation);
    }

    public static boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (stack.func_77973_b() instanceof ItemBlockGrave) {
            NBTStackHelper.setString(stack, "engraved_name", engraved_name);
            return true;
        }
        return false;
    }

    public static boolean isEngraved(ItemStack stack) {
        return !ItemBlockGrave.getEngravedName(stack).isEmpty();
    }

    public static String getEngravedName(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemBlockGrave ? NBTStackHelper.getString(stack, "engraved_name") : "";
    }
}

