/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Perk
extends ForgeRegistryEntry<Perk>
implements Comparable<Perk>,
IStringSerializable {
    protected final String name;
    protected final ResourceLocation icon;

    public Perk(String name, ResourceLocation icon) {
        this.name = name;
        this.icon = icon;
    }

    public abstract int getLevelMax();

    public abstract boolean isDisabled();

    @OnlyIn(value=Dist.CLIENT)
    public abstract String getTooltip(int var1, int var2, int var3);

    public abstract int getCost(int var1);

    public boolean isEncrypted() {
        return false;
    }

    public int getLevelBonus(EntityPlayer player) {
        return 0;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getUnlocalizedName() {
        return "tombstone.perk." + this.name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getClientTranslation() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public boolean equals(Object object) {
        assert (this.getRegistryName() != null);
        return object instanceof Perk && this.getRegistryName().equals((Object)((Perk)object).getRegistryName());
    }

    @Override
    public int compareTo(Perk perk) {
        assert (this.getRegistryName() != null && perk.getRegistryName() != null);
        return this.getRegistryName().compareTo(perk.getRegistryName());
    }
}

