/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.helper.Helper;

public class PerkDisenchanter
extends Perk {
    public PerkDisenchanter() {
        super("disenchanter", new ResourceLocation("tombstone", "textures/item/book_of_disenchantment.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)ConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get() == false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == actualLevel || actualLevel == 0 && level == 1 || level == levelWithBonus) {
            return level + 1 + " " + I18n.func_135052_a((String)("tombstone.perk." + this.name + ".desc"), (Object[])new Object[0]);
        }
        if (level == actualLevel + 1) {
            return level + 1 + "";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }
}

