/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

public class PerkGhostlyShape
extends Perk {
    public PerkGhostlyShape() {
        super("ghostly_shape", new ResourceLocation("tombstone", "textures/potion/ghostly_shape.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled() {
        return (Integer)ConfigTombstone.general.ghostlyShapeDuration.get() <= 0;
    }

    @Override
    public String getUnlocalizedName() {
        return "tombstone.potion.ghostly_shape";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == 1) {
            return "tombstone.potion.feather_fall";
        }
        if (level == 2) {
            return LangKey.MESSAGE_BREATHING.getClientTranslation(new Object[0]);
        }
        if (level == 3) {
            return "tombstone.potion.purification";
        }
        if (level == 4) {
            return "tombstone.potion.true_sight";
        }
        if (level == 5) {
            return LangKey.MESSAGE_INVULNERABLE.getClientTranslation(new Object[0]);
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level < 1 ? 0 : (level > 4 ? 2 : 1);
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }
}

