/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.helper.Helper;

public class PerkVoodooPoppet
extends Perk {
    public PerkVoodooPoppet() {
        super("voodoo_poppet", new ResourceLocation("tombstone", "textures/item/voodoo_poppet.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled() {
        return (Boolean)ConfigTombstone.allowed_magic_items.allowVoodooPoppet.get() == false;
    }

    @Override
    public String getUnlocalizedName() {
        return "tombstone.item.voodoo_poppet";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == 1) {
            return "tombstone.item.voodoo_poppet.drown";
        }
        if (level == 2) {
            return "tombstone.item.voodoo_poppet.burn";
        }
        if (level == 3) {
            return "tombstone.item.voodoo_poppet.starve";
        }
        if (level == 4) {
            return "tombstone.item.voodoo_poppet.fall";
        }
        if (level == 5) {
            return "tombstone.item.voodoo_poppet.wither";
        }
        return "";
    }

    @Override
    public int getCost(int level) {
        return level < 1 ? 0 : (level > 4 ? 2 : 1);
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }
}

