/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class TBCapabilityDefault
implements ITBCapability {
    protected long knowledge = 0L;
    private final HashMap<Perk, Integer> perks = new HashMap();
    private long nextPray = -1L;

    @Override
    public long getKnowledge() {
        return this.knowledge;
    }

    @Override
    public ITBCapability addKnowledge(long points) {
        this.knowledge += points;
        return this;
    }

    @Override
    public ITBCapability setKnowledge(long points) {
        this.knowledge = points;
        return this;
    }

    @Override
    public long getKnowledge(int level) {
        return level <= 0 ? 0L : (long)(level * level * 2);
    }

    @Override
    public long getKnowledgeForLevel(int level) {
        return level <= 0 ? 0L : (long)(4 * level - 2);
    }

    @Override
    public int getUsedPerkPoints(EntityPlayer player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(player, entry.getKey())) {
                it.remove();
                continue;
            }
            Perk perk = entry.getKey();
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += perk.getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)MathHelper.func_76129_c((float)((float)this.knowledge / 2.0f));
    }

    @Override
    public HashMap<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public ITBCapability setPerks(HashMap<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public boolean hasPerk(Perk perk) {
        return this.perks.containsKey(perk);
    }

    @Override
    public ITBCapability setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
        return this;
    }

    @Override
    public boolean removePerk(Perk perk) {
        return this.perks.remove(perk) != null;
    }

    @Override
    public int getPerkLevel(EntityPlayer player, Perk perk) {
        if (Helper.isDisabledPerk(player, perk)) {
            return 0;
        }
        return this.perks.getOrDefault(perk, 0);
    }

    @Override
    public boolean canPray(EntityPlayer player) {
        return TimeHelper.worldTicks(player.field_70170_p) >= this.nextPray;
    }

    @Override
    public ITBCapability resetNextPray(EntityPlayerMP player) {
        this.nextPray = TimeHelper.worldTicks(player.field_70170_p) + (long)this.getMaxPrayTime((EntityPlayer)player);
        return this;
    }

    @Override
    public int getMaxPrayTime(EntityPlayer player) {
        return TimeHelper.tickFromHour(Helper.isContributor(player) ? 3 : 6);
    }

    @Override
    public long getNextPray() {
        return this.nextPray;
    }

    @Override
    public ITBCapability setNextPray(long time) {
        this.nextPray = time;
        return this;
    }

    @Override
    public ITBCapability copyCapability(ITBCapability otherTBCapability) {
        this.setKnowledge(otherTBCapability.getKnowledge());
        this.setPerks(otherTBCapability.getPerks());
        this.setNextPray(otherTBCapability.getNextPray());
        return this;
    }
}

