/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.PerkRegistry;

public class TBCapabilityStorage
implements Capability.IStorage<ITBCapability> {
    public void readNBT(Capability<ITBCapability> capability, ITBCapability instance, EnumFacing side, INBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        if (tag.func_150297_b("knowledge", 4)) {
            instance.setKnowledge(tag.func_74763_f("knowledge"));
        }
        if (tag.func_150297_b("next_pray", 4)) {
            instance.setNextPray(tag.func_74763_f("next_pray"));
        }
        if (tag.func_150297_b("perks", 9)) {
            NBTTagList tagPerks = tag.func_150295_c("perks", 10);
            IntStream.range(0, tagPerks.size()).mapToObj(arg_0 -> ((NBTTagList)tagPerks).func_150305_b(arg_0)).filter(tagPerk -> tagPerk.func_150297_b("id", 3) && tagPerk.func_150297_b("level", 3)).forEach(tagPerk -> {
                Perk perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"));
                if (perk != null && !perk.isDisabled()) {
                    instance.setPerk(perk, Math.min(perk.getLevelMax(), tagPerk.func_74762_e("level")));
                }
            });
        }
    }

    @Nullable
    public INBTBase writeNBT(Capability<ITBCapability> capability, ITBCapability instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("knowledge", instance.getKnowledge());
        tag.func_74772_a("next_pray", instance.getNextPray());
        NBTTagList tagPerks = new NBTTagList();
        instance.getPerks().forEach((perk, value) -> {
            if (perk != null && !perk.isDisabled()) {
                NBTTagCompound tagPerk = new NBTTagCompound();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)perk));
                tagPerk.func_74768_a("level", Math.min(perk.getLevelMax(), value));
                tagPerks.add((INBTBase)tagPerk);
            }
        });
        tag.func_74782_a("perks", (INBTBase)tagPerks);
        return tag;
    }
}

