/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TeleportUtils;

public class CommandTBRecovery
extends TombstoneCommand {
    public CommandTBRecovery(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbrecovery";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.showUsage((CommandSource)c.getSource()));
        builder.then(Commands.func_197057_a((String)"save_all_players").executes(c -> CommandTBRecovery.saveAllPlayers(((CommandSource)c.getSource()).func_197028_i(), success -> this.sendMessage((CommandSource)c.getSource(), (ITextComponent)new TextComponentString(success != false ? "All players have been successfully backed up" : "Some players could not be backed up"), true))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"save_player").executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> {
            EntityPlayerMP player = EntityArgument.func_197089_d((CommandContext)c, (String)"player");
            return this.savePlayer(player, success -> this.sendMessage((CommandSource)c.getSource(), (success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getTranslation(player.func_200200_C_()), false));
        })));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"load_player").executes(c -> this.showUsage((CommandSource)c.getSource()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.loadPlayer((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), ".latest"))).then(Commands.func_197056_a((String)"file_string", (ArgumentType)StringArgumentType.string()).suggests((ctx, build) -> {
            File[] matchingFiles;
            EntityPlayerMP player = EntityArgument.func_197089_d((CommandContext)ctx, (String)"player");
            List<Object> list = new ArrayList();
            File checkedFile = new File(((CommandSource)ctx.getSource()).func_197028_i().func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "tombstone/saved_players/" + player.func_110124_au());
            if (checkedFile.exists() && (matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"))) != null) {
                list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
                list.add(".latest");
                list.add(".oldest");
            }
            return ISuggestionProvider.func_197005_b(list, (SuggestionsBuilder)build);
        }).executes(c -> this.loadPlayer((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), StringArgumentType.getString((CommandContext)c, (String)"file_string"))))));
        return builder;
    }

    public static int saveAllPlayers(MinecraftServer server, Consumer<Boolean> callback) throws CommandException {
        File baseFolder = new File(server.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "tombstone/saved_players");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder cannot be created");
            callback.accept(false);
            return 1;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean hasPlayerSkipped = false;
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            if (!player.func_70089_S() || player.func_175149_v()) continue;
            File playerFolder = CommandTBRecovery.getPlayerFolder(player);
            if (playerFolder == null) {
                hasPlayerSkipped = true;
                continue;
            }
            pairs.add(Pair.of((Object)player.func_189511_e(new NBTTagCompound()), (Object)playerFolder));
        }
        if (pairs.size() == 0) {
            callback.accept(true);
            return 1;
        }
        boolean skipped = hasPlayerSkipped;
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            boolean wasSuccessful = !skipped;
            for (Pair pair : pairs) {
                boolean success = CommandTBRecovery.savePlayerData((NBTTagCompound)pair.getLeft(), (File)pair.getRight());
                if (success) continue;
                wasSuccessful = false;
            }
            boolean isSuccessful = wasSuccessful;
            server.func_152344_a(() -> callback.accept(isSuccessful));
            return false;
        });
        return 1;
    }

    private int savePlayer(EntityPlayerMP player, Consumer<Boolean> callback) throws CommandException {
        this.checkAlive((Entity)player);
        this.checkNotSpectator((EntityPlayer)player);
        File playerFolder = CommandTBRecovery.getPlayerFolder(player);
        if (playerFolder == null) {
            callback.accept(false);
            return 1;
        }
        MinecraftServer listener = player.field_71133_b;
        NBTTagCompound tag = player.func_189511_e(new NBTTagCompound());
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> CommandTBRecovery.lambda$savePlayer$15(tag, playerFolder, (IThreadListener)listener, callback));
        return 1;
    }

    private static boolean savePlayerData(NBTTagCompound tag, File saveFolder) {
        String dateString = new SimpleDateFormat("yyyyMMdd-hhmmss", Locale.US).format(new Date());
        try {
            FileWriter writer = new FileWriter(new File(saveFolder, dateString + ".save"));
            writer.write(tag.toString());
            writer.close();
            File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles != null && matchingFiles.length > (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get()) {
                Arrays.sort(matchingFiles, File::compareTo);
                int num = 0;
                for (File file2 : matchingFiles) {
                    if (num >= matchingFiles.length - (Integer)ConfigTombstone.recovery.recoveryPlayerMaxSaves.get()) break;
                    file2.delete();
                    ++num;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    private static File getPlayerFolder(EntityPlayerMP player) {
        File saveFolder = new File(player.field_71133_b.func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "tombstone/saved_players/" + player.func_110124_au());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder cannot be created");
            return null;
        }
        return saveFolder;
    }

    private int loadPlayer(CommandSource sender, EntityPlayerMP player, String fileString) throws CommandException {
        String fileName;
        this.checkAlive((Entity)player);
        this.checkNotSpectator((EntityPlayer)player);
        File saveFolder = new File(sender.func_197028_i().func_71218_a(DimensionType.OVERWORLD).func_72860_G().func_75765_b(), "tombstone/saved_players/" + player.func_110124_au());
        if (!saveFolder.exists()) {
            player.func_145747_a(LangKey.MESSAGE_RECOVERY_NO_FOLDER.getTranslation(saveFolder.getAbsolutePath()));
            return 1;
        }
        if (fileString.equals(".latest") || fileString.equals(".oldest")) {
            File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
            if (saveFiles == null || saveFiles.length == 0) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FOLDER.getTranslation(fileString));
            }
            Optional<File> res = fileString.equals(".latest") ? Stream.of(saveFiles).max(File::compareTo) : Stream.of(saveFiles).min(File::compareTo);
            fileName = res.get().getName();
        } else {
            fileName = fileString + ".save";
            File[] files = saveFolder.listFiles(p -> p.isFile() && p.getName().equals(fileName));
            if (files == null || files.length == 0) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FILE.getTranslation(fileName));
            }
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(saveFolder, fileName)));
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)reader.readLine());
            reader.close();
            if (!nbt.func_150296_c().isEmpty()) {
                int originalDim = Helper.getDimensionId((IWorld)player.field_70170_p);
                player.deserializeNBT(nbt);
                TeleportUtils.teleportEntity((Entity)player, Helper.getDimensionId((IWorld)player.field_70170_p), player.field_70165_t, player.field_70163_u, player.field_70161_v);
                if (originalDim == Helper.getDimensionId((IWorld)player.field_70170_p)) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                    for (PotionEffect potioneffect : player.func_70651_bq()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
                    }
                }
            } else {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getTranslation(player.func_200200_C_()));
            }
            player.func_145747_a(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_TARGET_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
            this.sendMessage(sender, LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getTranslation(player.func_200200_C_()), false);
        }
        catch (Exception e) {
            throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getTranslation(player.func_200200_C_()));
        }
        return 1;
    }

    private static /* synthetic */ boolean lambda$savePlayer$15(NBTTagCompound tag, File playerFolder, IThreadListener listener, Consumer callback) {
        boolean result = CommandTBRecovery.savePlayerData(tag, playerFolder);
        listener.func_152344_a(() -> callback.accept(result));
        return false;
    }
}

