/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBRequestTeleport
extends TombstoneCommand {
    private static final List<Ticket> ticketList = new ArrayList<Ticket>();

    public CommandTBRequestTeleport(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbrequestteleport";
    }

    @Override
    public ITextComponent getUsage() {
        return new TextComponentString("This command shouldn't be called manually");
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"source", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"target", (ArgumentType)StringArgumentType.word()).executes(c -> this.requestTeleport((CommandSource)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"source"), StringArgumentType.getString((CommandContext)c, (String)"target")))));
    }

    private int requestTeleport(CommandSource sender, String sourceString, String targetString) throws CommandException {
        EntityPlayerMP player = sender.func_197028_i().func_184103_al().func_177451_a(UUID.fromString(sourceString));
        EntityPlayerMP target = sender.func_197028_i().func_184103_al().func_177451_a(UUID.fromString(targetString));
        if (player == null || target == null) {
            throw new CommandException(LangKey.MESSAGE_PLAYER_INVALID.getTranslation());
        }
        boolean valid = ticketList.removeIf(p -> ((Ticket)p).playerUUID.equals(player.func_110124_au()) && ((Ticket)p).targetUUID.equals(target.func_110124_au()) && ((Ticket)p).expiredTime >= TimeHelper.systemTime());
        if (valid) {
            Location spawnLoc = new SpawnHelper(target.func_71121_q(), target.func_180425_c()).findSafePlace(3, true, true);
            EntityPlayerMP newPlayer = Helper.teleportEntity(player, spawnLoc.isOrigin() ? new Location((Entity)target) : spawnLoc);
            newPlayer.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
            target.func_145747_a(LangKey.MESSAGE_JOIN_YOU.getTranslationWithStyle(StyleType.MESSAGE_SPELL, newPlayer.func_200200_C_()));
            return 1;
        }
        throw new CommandException(LangKey.MESSAGE_NO_TICKET.getTranslation());
    }

    public static void addTicket(EntityPlayer player, EntityPlayer target, int duration) {
        ticketList.add(new Ticket(player.func_110124_au(), target.func_110124_au(), TimeHelper.systemTime() + TimeUnit.SECONDS.toMillis(duration)));
    }

    public static void cleanTickets(long time) {
        ticketList.removeIf(p -> ((Ticket)p).expiredTime < time);
    }

    public static class Ticket {
        private final UUID playerUUID;
        private final UUID targetUUID;
        private long expiredTime;

        Ticket(UUID playerUUID, UUID targetUUID, long expiredTime) {
            this.playerUUID = playerUUID;
            this.targetUUID = targetUUID;
            this.expiredTime = expiredTime;
        }
    }
}

