/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBShowLastGrave
extends TombstoneCommand {
    public CommandTBShowLastGrave(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbshowlastgrave";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.getLastGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h()));
        builder.then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.getLastGrave((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"))));
        return builder;
    }

    private int getLastGrave(CommandSource sender, EntityPlayerMP target) throws CommandException {
        String targetName = target.func_200200_C_().func_150261_e();
        Location lastGrave = DeathHandler.instance.getLastGrave(targetName);
        if (lastGrave.isOrigin()) {
            lastGrave = (Location)target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.grave_key).findFirst().map(ModItems.grave_key::getTombPos).orElse(Location.ORIGIN)).orElse((Object)Location.ORIGIN);
        }
        if (lastGrave.isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_GRAVE.getTranslation());
        }
        this.sendMessage(sender, LangKey.MESSAGE_LAST_GRAVE_PLACE.getTranslation(targetName, LangKey.MESSAGE_LAST_GRAVE.getTranslation(), lastGrave.x, lastGrave.y, lastGrave.z, lastGrave.dim), false);
        return 1;
    }
}

