/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.VillageSiegeHandler;

public class CommandTBSiege
extends TombstoneCommand {
    public CommandTBSiege(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbsiege";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.launchSiege((CommandSource)c.getSource(), 0));
        builder.then(Commands.func_197056_a((String)"dim", (ArgumentType)IntegerArgumentType.integer()).suggests((ctx, build) -> ISuggestionProvider.func_197005_b(Helper.getDimensionIdsAsStringList(), (SuggestionsBuilder)build)).executes(c -> this.launchSiege((CommandSource)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"dim"))));
        return builder;
    }

    private int launchSiege(CommandSource sender, int dim) throws CommandException {
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw new CommandException(LangKey.MESSAGE_DISABLED.getTranslation());
        }
        DimensionType dimensionType = this.getOrThrowDimensionType(dim);
        WorldServer world = DimensionManager.getWorld((MinecraftServer)sender.func_197028_i(), (DimensionType)dimensionType, (boolean)false, (boolean)false);
        if (world == null) {
            throw new CommandException(LangKey.MESSAGE_UNLOADED_DIMENSION.getTranslation());
        }
        if (world.func_72912_H().func_176130_y() == EnumDifficulty.PEACEFUL) {
            throw new CommandException(LangKey.MESSAGE_DIFFICULTY_PEACEFUL.getTranslation());
        }
        ResourceLocation dimensionString = DimensionType.func_212678_a((DimensionType)dimensionType);
        if (dimensionString == null || ((List)ConfigTombstone.village_siege.deniedDimensionTypeForSiege.get()).contains(dimensionString.toString())) {
            throw new CommandException(LangKey.MESSAGE_DENIED_DIMENSION.getTranslation());
        }
        if (world.func_72935_r()) {
            throw new CommandException(LangKey.MESSAGE_ONLY_AT_NIGHT.getTranslation());
        }
        if (world.field_175740_d instanceof VillageSiegeHandler.CustomVillageSiege) {
            VillageSiegeHandler.CustomVillageSiege villageSiege = (VillageSiegeHandler.CustomVillageSiege)world.field_175740_d;
            switch (villageSiege.field_75536_c) {
                case SIEGE_START: 
                case SPAWN_MOBS: {
                    throw new CommandException(LangKey.MESSAGE_START_SIEGE_FAILED.getTranslation());
                }
                case INIT: 
                case SIEGE_END: 
                case DAY_TIME: {
                    villageSiege.hasFailedTrySiege = false;
                    villageSiege.field_75536_c = VillageSiegeHandler.SiegeState.SIEGE_START;
                    this.sendMessage(sender, LangKey.MESSAGE_START_SIEGE_SUCCESS.getTranslation(), false);
                }
            }
        }
        return 1;
    }
}

