/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.CapabilityItemHandler;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

public class CommandTBTeleportGrave
extends TombstoneCommand {
    public CommandTBTeleportGrave(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleportgrave";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.teleportGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), ((CommandSource)c.getSource()).func_197035_h()));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportGrave((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), EntityArgument.func_197089_d((CommandContext)c, (String)"player")))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> this.teleportGrave((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), EntityArgument.func_197089_d((CommandContext)c, (String)"target")))));
        return builder;
    }

    private int teleportGrave(CommandSource sender, EntityPlayerMP player, EntityPlayerMP target) throws CommandException {
        DimensionType dimensionType;
        this.checkAlive((Entity)player);
        this.checkNotSpectator((EntityPlayer)player);
        DeathHandler deathHandler = DeathHandler.instance;
        Location lastGrave = deathHandler.getLastGrave(target.func_146103_bH().getName());
        if (!lastGrave.isOrigin()) {
            dimensionType = this.getOrThrowDimensionType(lastGrave.dim);
            if (!(sender.func_197028_i().func_71218_a(dimensionType).func_175625_s(lastGrave.getPos()) instanceof TileEntityGrave)) {
                deathHandler.removeGrave(lastGrave);
                lastGrave = Location.ORIGIN;
            }
        }
        if (lastGrave.isOrigin() && (lastGrave = (Location)target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> IntStream.range(0, itemHandler.getSlots()).mapToObj(i -> ModItems.grave_key.getTombPos(itemHandler.getStackInSlot(i))).filter(location -> !location.isOrigin()).findFirst().orElse(Location.ORIGIN)).orElse((Object)Location.ORIGIN)).isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_GRAVE.getTranslation());
        }
        dimensionType = this.getOrThrowDimensionType(lastGrave.dim);
        this.checkValidPos((World)sender.func_197028_i().func_71218_a(dimensionType), lastGrave.getPos());
        EntityPlayerMP newEntity = Helper.teleportToGrave(player, lastGrave);
        if (EntityHelper.isValidPlayer((Entity)newEntity)) {
            newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(), lastGrave.x, lastGrave.y, lastGrave.z, lastGrave.dim), false);
        return 1;
    }
}

