/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.village.Village;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;

public class CommandTBTeleportVillage
extends TombstoneCommand {
    public CommandTBTeleportVillage(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    public String getName() {
        return "tbteleportvillage";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        builder.executes(c -> this.showUsage((CommandSource)c.getSource()));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(c -> this.showUsage((CommandSource)c.getSource()))).then(Commands.func_197056_a((String)"villageString", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, build) -> ISuggestionProvider.func_197005_b((Iterable)((CommandSource)ctx.getSource()).func_197023_e().func_175714_ae().func_75540_b().stream().map(p -> p.func_180608_a().func_177958_n() + "," + p.func_180608_a().func_177956_o() + "," + p.func_180608_a().func_177952_p()).collect(Collectors.toList()), (SuggestionsBuilder)build)).executes(c -> this.teleportVillage((CommandSource)c.getSource(), EntityArgument.func_197088_a((CommandContext)c, (String)"target"), StringArgumentType.getString((CommandContext)c, (String)"villageString")))));
        return builder;
    }

    private int teleportVillage(CommandSource sender, Entity target, String villageString) throws CommandException {
        this.checkAlive(target);
        this.checkNotSpectator(target);
        Village currentVillage = sender.func_197023_e().func_175714_ae().func_75540_b().stream().filter(village -> villageString.equals(village.func_180608_a().func_177958_n() + "," + village.func_180608_a().func_177956_o() + "," + village.func_180608_a().func_177952_p())).findFirst().orElse(null);
        if (currentVillage == null) {
            throw new CommandException(LangKey.MESSAGE_INVALID_VILLAGE.getTranslation());
        }
        Location spawnLoc = Helper.findSpawnForVillage(sender.func_197023_e(), currentVillage.func_180608_a());
        if (spawnLoc.isOrigin()) {
            throw new CommandException(LangKey.MESSAGE_NO_SPAWN.getTranslation());
        }
        Entity newEntity = Helper.teleportEntity(target, spawnLoc);
        if (EntityHelper.isValidPlayer(newEntity)) {
            newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL));
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getTranslation(newEntity.func_200200_C_(), LangKey.MESSAGE_HERE.getTranslation(), spawnLoc.x, spawnLoc.y, spawnLoc.z, spawnLoc.dim), false);
        return 1;
    }
}

