/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneEnchantment
extends Enchantment {
    private final String customName;

    TombstoneEnchantment(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot[] slots) {
        super(rarity, type, slots);
        this.customName = name;
    }

    protected abstract boolean isEnabled();

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int lvl) {
        return 1;
    }

    public int func_77317_b(int lvl) {
        return 50;
    }

    protected boolean func_77326_a(Enchantment ench) {
        return !ench.func_190936_d() && !ench.func_77320_a().equalsIgnoreCase(this.field_77350_z) && super.func_77326_a(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipInfos(ItemStack stack) {
        ArrayList<ITextComponent> infos = new ArrayList<ITextComponent>();
        if (stack.func_77973_b() instanceof ItemEnchantedBook) {
            infos.add(new TextComponentString(LangKey.getClientTranslation(this.func_77320_a() + ".desc", new Object[0])).func_150255_a(StyleType.TOOLTIP_ENCHANT.getStyle()));
        }
        if (!this.isEnabled()) {
            infos.add((ITextComponent)new TextComponentString(LangKey.getClientTranslation("enchantment.tombstone.disabled", new Object[0])));
        }
        return infos;
    }

    public String func_77320_a() {
        return "enchantment.tombstone." + this.customName;
    }
}

