/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final KeyBinding keybindKnowledge = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "Corail Tombstone");
    private static boolean isGhostlyRender;
    private static boolean hasTrueSight;
    private static boolean isFirstGuiGameOver;
    private static boolean requireRemovalNightVision;
    private static boolean delayedGui;
    private static long nextGhostTime;

    @SubscribeEvent
    public static void onCommandEvent(CommandEvent event) {
        if ("/tbgui".equals(event.getParseResults().getReader().getString())) {
            delayedGui = true;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        event.getMap().func_199362_a(resourceManager, new ResourceLocation("tombstone", "particle/fake_fog"));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT && event.player != null && event.player == Minecraft.func_71410_x().field_71439_g) {
            if (keybindKnowledge.func_151468_f() || delayedGui) {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat) {
                    mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                        delayedGui = false;
                        mc.func_147108_a((GuiScreen)new GuiKnowledge((ITBCapability)cap));
                    });
                }
            }
            if (((Boolean)ConfigTombstone.client.enableHalloweenEffect.get()).booleanValue() && Helper.isDateAroundHalloween()) {
                if (Helper.isNight(event.player.field_70170_p)) {
                    long time = event.player.field_70170_p.func_82737_E();
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && EntityHelper.canPray(event.player)) {
                            BlockPos pos = event.player.func_180425_c().func_177982_a(Helper.getRandom(-9, 9), 0, Helper.getRandom(-9, 9));
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleGhost(event.player.field_70170_p, pos));
                            event.player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(event.player.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                            Minecraft.func_71410_x().field_71441_e.func_184156_a(pos, Helper.getRandom(0, 3) == 0 ? ModSounds.GHOST_LAUGH : ModSounds.GHOST_HOWL, SoundCategory.VOICE, 1.0f, 1.0f, true);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        EntityPlayerSP player;
        if (((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && event.getGui() instanceof GuiGameOver && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (hasTrueSight && event.getBlockState().func_185904_a() == Material.field_151586_h) {
            event.setCanceled(true);
            event.setDensity(event.getDensity() / 4.0f);
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight && event.getBlockState().func_185904_a() == Material.field_151586_h) {
            event.setRed(0.09019608f);
            event.setGreen(0.41568628f);
            event.setBlue(0.9254902f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if (hasTrueSight && event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!EntityHelper.isValidPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                return;
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            boolean bl = hasTrueSight = EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape, 4) || EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.true_sight);
            if (hasTrueSight && !EntityHelper.isPotionActive((EntityLivingBase)player, MobEffects.field_76439_r)) {
                player.func_195064_c(new PotionEffect(MobEffects.field_76439_r, 1200, 0, true, false));
                requireRemovalNightVision = true;
            }
        } else if (requireRemovalNightVision) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(MobEffects.field_76439_r);
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Minecraft.func_71410_x().field_71439_g.func_184596_c(MobEffects.field_76439_r);
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && SupportMods.canDisplayTooltipOnEnchant() && event.getItemStack().func_77942_o()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)event.getItemStack());
            block0: for (Enchantment enchant : enchantments.keySet()) {
                if (!(enchant instanceof TombstoneEnchantment)) continue;
                for (int line = 0; line < event.getToolTip().size(); ++line) {
                    ITextComponent currentTooltip = (ITextComponent)event.getToolTip().get(line);
                    if (!(currentTooltip instanceof TextComponentTranslation) || !enchant.func_77320_a().equals(((TextComponentTranslation)currentTooltip).func_150268_i())) continue;
                    for (ITextComponent translation : ((TombstoneEnchantment)enchant).getTooltipInfos(event.getItemStack())) {
                        event.getToolTip().add(++line, translation);
                    }
                    continue block0;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        boolean bl = isGhostlyRender = EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape) || EntityHelper.getPotionDuration((EntityLivingBase)player, ModEffects.unstable_intangibleness) % 100 > 79;
        if (isGhostlyRender) {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (isGhostlyRender) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Location location;
        if (!((Boolean)ConfigTombstone.client.highlight.get()).booleanValue()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.grave_key) {
            location = ModItems.grave_key.getTombPos(stack);
        } else if (stack.func_77973_b() == ModItems.tablet_of_recall) {
            location = ModItems.tablet_of_recall.getTombPos(stack);
        } else if (ModItems.lost_tablet.isWakeUp(stack)) {
            location = ModItems.lost_tablet.getStructurePos(stack);
        } else {
            return;
        }
        BlockPos playerPos = player.func_180425_c();
        if (location.isOrigin() || location.dim != player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() || !World.func_175701_a((BlockPos)location.getPos())) {
            return;
        }
        if (location.getPos().func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o() + 1, playerPos.func_177952_p()) > 200.0) {
            Vec3d vec = new Vec3d((Vec3i)location.getPos()).func_178788_d(player.func_174791_d()).func_72432_b();
            location.x = (int)(player.func_174791_d().field_72450_a + vec.field_72450_a * 200.0);
            location.y = (int)(player.func_174791_d().field_72448_b + vec.field_72448_b * 200.0);
            location.z = (int)(player.func_174791_d().field_72449_c + vec.field_72449_c * 200.0);
        }
        double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        long c = TimeHelper.systemTime() / 15L % 360L;
        float[] color = Helper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        float x = location.x;
        float y = location.y;
        float z = location.z;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        GlStateManager.func_179131_c((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        GL11.glLineWidth((float)2.5f);
        GlStateManager.func_179123_a();
        GL11.glDisable((int)2929);
        float offset = 1.0f;
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)z).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)(y + offset), (double)z).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)(x + offset), (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, (double)(z + offset)).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + offset), (double)(z + offset)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)keybindKnowledge);
        isGhostlyRender = false;
        hasTrueSight = false;
        isFirstGuiGameOver = false;
        requireRemovalNightVision = false;
        delayedGui = false;
        nextGhostTime = -1L;
    }
}

