/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PhantomSpawnerHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.VillageSiegeHandler;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.tileentity.TileEntityGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static ResourceLocation LOOTTABLE_SPECIAL = new ResourceLocation("tombstone", "loot_tables/special.json");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LOOTTABLE_SPECIAL)) {
            LootTable targetTable = event.getLootTableManager().func_186521_a(LootTableList.field_186388_am);
            if (targetTable != LootTable.field_186464_a) {
                LootPool fishTreasure = event.getTable().getPool("tombstone:lost_tablet");
                fishTreasure.getEntry((String)"tombstone:lost_tablet").field_186364_c = (Integer)ConfigTombstone.loot.chanceLootLostTablet.get();
                fishTreasure.getEntry((String)"empty").field_186364_c = 100 - (Integer)ConfigTombstone.loot.chanceLootLostTablet.get();
                ObfuscationReflectionHelper.setPrivateValue(LootTable.class, (Object)targetTable, (Object)false, (String)"isFrozen");
                targetTable.addPool(fishTreasure);
                ObfuscationReflectionHelper.setPrivateValue(LootTable.class, (Object)targetTable, (Object)true, (String)"isFrozen");
            }
            LootPool chestTreasure = event.getTable().getPool("tombstone:chest_treasure");
            for (String targetTableString : (List)ConfigTombstone.loot.treasureLootTable.get()) {
                targetTable = event.getLootTableManager().func_186521_a(new ResourceLocation(targetTableString));
                if (targetTable == LootTable.field_186464_a) continue;
                ObfuscationReflectionHelper.setPrivateValue(LootTable.class, (Object)targetTable, (Object)false, (String)"isFrozen");
                targetTable.addPool(chestTreasure);
                ObfuscationReflectionHelper.setPrivateValue(LootTable.class, (Object)targetTable, (Object)true, (String)"isFrozen");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long systemTicks;
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && TimeHelper.atInterval(systemTicks = TimeHelper.systemTicks(), TimeHelper.tickFromMinute(1))) {
            if (((Boolean)ConfigTombstone.recovery.recoveryPlayerEnable.get()).booleanValue() && TimeHelper.atInterval(systemTicks, TimeHelper.tickFromMinute((Integer)ConfigTombstone.recovery.recoveryPlayerTimer.get()))) {
                CommandTBRecovery.saveAllPlayers((MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER), success -> ModTombstone.LOGGER.info(success != false ? "All players have been successfully backed up" : "Some players could not be backed up"));
            }
            CommandTBRequestTeleport.cleanTickets(systemTicks);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof BlockGraveBase);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue() && EntityHelper.isPotionActive((EntityLivingBase)event.getPlayer(), ModEffects.ghostly_shape)) {
            event.getPlayer().func_195063_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClickChest(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND && ((Boolean)ConfigTombstone.general.nerfGhostlyShape.get()).booleanValue() && EntityHelper.isPotionActive((EntityLivingBase)event.getEntityPlayer(), ModEffects.ghostly_shape) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockChest) {
            event.getEntityPlayer().func_195063_d(ModEffects.ghostly_shape);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            VillageSiegeHandler.instance.checkWorld((WorldServer)event.getWorld());
            PhantomSpawnerHandler.instance.checkWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.unstable_intangibleness) && EntityHelper.getPotionDuration(event.getEntityLiving(), ModEffects.unstable_intangibleness) % 100 > 79) {
            event.setCanceled(true);
            return;
        }
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EntityHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_180425_c())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() != null && EntityHelper.isValidPlayer(event.getSource().func_76346_g())) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (event.getEntityLiving() != player) {
                if (EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape)) {
                    player.func_195063_d(ModEffects.ghostly_shape);
                    Helper.grantAdvancement(player, "adventure/cancel_ghostly_shape", new String[0]);
                }
                if (EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.diversion)) {
                    player.func_195063_d(ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving()) && event.getEntityLiving().func_110143_aJ() <= event.getAmount()) {
            Location spawnPos;
            ItemStack soul;
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            ItemVoodooPoppet.PoppetProtections prot = ModItems.voodoo_poppet.getPoppetProtections(event.getSource());
            if (prot != null && ModItems.voodoo_poppet.preventDeath((EntityPlayer)player, InventoryHelper.findItemInMainInventory((EntityPlayer)player, p -> ModItems.voodoo_poppet.canPreventDeath((ItemStack)p, prot)), prot)) {
                event.setCanceled(true);
                player.func_145747_a(prot.getLangKey().getTranslation().func_150255_a(StyleType.MESSAGE_SPECIAL.getStyle()));
                Helper.grantAdvancement((EntityPlayer)player, "adventure/prevent_death_" + prot.getName(), new String[0]);
                Helper.grantAdvancement((EntityPlayer)player, "adventure/death_master", "has_prevent_" + prot.getName());
                return;
            }
            boolean preventDeathOutsideWorld = (Boolean)ConfigTombstone.general.preventDeathOutsideWorld.get() != false && !Helper.isValidPos(player.field_70170_p, player.func_180425_c());
            ItemStack itemStack = soul = !preventDeathOutsideWorld ? InventoryHelper.findItemInMainInventory((EntityPlayer)player, p -> p.func_77973_b() == ModItems.soul_receptacle) : ItemStack.field_190927_a;
            if (!(!preventDeathOutsideWorld && soul.func_190926_b() || (spawnPos = new SpawnHelper((WorldServer)player.field_70170_p, Helper.getCloserValidPos(player.field_70170_p, new BlockPos((Entity)player))).findSpawnPlace(false)).isOrigin())) {
                event.setCanceled(true);
                if (!preventDeathOutsideWorld) {
                    soul.func_190918_g(1);
                }
                player.func_70606_j(player.func_110138_aP());
                EntityHelper.clearBadEffects((EntityLivingBase)player);
                EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, 1200, 10, new boolean[0]);
                EntityHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
                EntityHelper.addPotion((EntityLivingBase)player, ModEffects.diversion, 1200);
                player.func_145747_a((preventDeathOutsideWorld ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).getTranslation());
                Helper.teleportEntity(player, spawnPos);
                player.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttack(LivingSetAttackTargetEvent event) {
        int lvl;
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || event.getTarget() == null) {
            return;
        }
        EntityLivingBase attacker = event.getEntityLiving();
        if (EntityHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EntityHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
            ((EntityLiving)attacker).field_70696_bz = null;
            if (attacker.field_70755_b == event.getTarget()) {
                attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
            }
            return;
        }
        if (!ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() || ((Boolean)ConfigTombstone.enchantments.restrictShadowStepToPlayer.get()).booleanValue() && !EntityHelper.isValidPlayer((Entity)event.getTarget())) {
            return;
        }
        if (ConfigTombstone.enchantments.isNerfShadowStep() && !event.getTarget().func_70093_af()) {
            return;
        }
        if (attacker.field_70755_b != event.getTarget() && !event.getTarget().func_184218_aH() && (lvl = EntityHelper.getEnchantmentLevel(event.getTarget(), ModEnchantments.shadow_step)) > 0) {
            IAttributeInstance attribute = attacker.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double range = attribute == null ? 16.0 : attribute.func_111126_e();
            double mult = (event.getTarget().func_70093_af() ? 0.8 : 1.0) - (double)lvl * 0.2 - (attacker.field_70170_p.func_72935_r() ? 0.0 : 0.1);
            if ((double)attacker.func_70032_d((Entity)event.getTarget()) < range * mult) {
                attacker.field_70755_b = event.getTarget();
                attacker.field_70756_c = attacker.field_70173_aa;
            } else {
                ((EntityLiving)attacker).field_70696_bz = null;
                if (attacker.field_70755_b == event.getTarget()) {
                    attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidPlayer(event.getPlayer()) || event.getPlayer().func_175149_v()) {
            return;
        }
        DeathHandler deathHandler = DeathHandler.instance;
        if (deathHandler.isPlayerDead(event.getPlayer())) {
            ListIterator it = event.getPlayer().field_71071_by.field_70462_a.listIterator();
            while (it.hasNext()) {
                if (!InventoryHelper.autoequip((ItemStack)it.next(), event.getPlayer())) continue;
                it.set(ItemStack.field_190927_a);
            }
            deathHandler.restorePlayerDead(event.getPlayer());
            event.getPlayer().field_71069_bz.func_75142_b();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onUndeadDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            DeathHandler.instance.handleMobDrops(event.getEntityLiving(), event.getSource(), event.getDrops());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void give(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayer original = event.getOriginal();
        if (!event.isWasDeath() || original == null || !EntityHelper.isValidPlayer(player)) {
            return;
        }
        if (!((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue() || Helper.isRuleKeepInventory(player)) {
            return;
        }
        ArrayList misplaced_stacks = new ArrayList();
        for (int i = 0; i < event.getOriginal().field_71071_by.field_70462_a.size(); ++i) {
            ItemStack originalStack = (ItemStack)event.getOriginal().field_71071_by.field_70462_a.get(i);
            if (originalStack.func_190926_b()) continue;
            int currentSlot = i;
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inventPlayer -> {
                ItemStack playerStack = inventPlayer.getStackInSlot(currentSlot);
                if (!playerStack.func_190926_b()) {
                    if (!ItemStack.func_77989_b((ItemStack)originalStack, (ItemStack)playerStack)) {
                        ModTombstone.LOGGER.warn("An item was different from the original");
                        misplaced_stacks.add(inventPlayer.extractItem(currentSlot, playerStack.func_190916_E(), false));
                        inventPlayer.insertItem(currentSlot, originalStack.func_77946_l(), false);
                    }
                } else {
                    inventPlayer.insertItem(currentSlot, originalStack.func_77946_l(), false);
                }
            });
        }
        for (ItemStack stack : misplaced_stacks) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        }
        DeathHandler.instance.addPlayerDead(original);
        if (!EntityHelper.isSurvivalPlayer(player)) {
            return;
        }
        boolean hasPreservation = EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.general.handlePlayerXp.get()).booleanValue()) {
            original.field_71067_cb = EntityHelper.getPlayerTotalXp(original);
            if (hasPreservation || (Integer)ConfigTombstone.general.xpLoss.get() == 0 || player.func_184812_l_()) {
                player.field_71067_cb = original.field_71067_cb;
                player.field_71106_cc = original.field_71106_cc;
                player.field_71068_ca = original.field_71068_ca;
            } else {
                int bonus = EntityHelper.getPerkLevelWithBonus(player, ModPerks.memento_mori) * 10;
                EntityHelper.setPlayerXp(player, original.field_71067_cb * MathHelper.func_76125_a((int)(100 + bonus - (Integer)ConfigTombstone.general.xpLoss.get()), (int)0, (int)100) / 100);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            return;
        }
        if (event.isCanceled()) {
            if (((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue()) {
                ModTombstone.LOGGER.warn("The death event of the player " + event.getEntityLiving().func_200200_C_() + " was cancelled by another mod");
            }
        } else {
            event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                INBTBase tbCapTag = TBCapabilityProvider.TB_CAPABILITY.writeNBT(cap, null);
                if (tbCapTag != null) {
                    NBTTagCompound entityData = event.getEntityLiving().getEntityData();
                    NBTTagCompound persistantTag = entityData.func_74764_b("PlayerPersisted") ? (NBTTagCompound)entityData.func_74781_a("PlayerPersisted") : new NBTTagCompound();
                    persistantTag.func_74782_a("tombstone_cap", tbCapTag);
                    entityData.func_74782_a("PlayerPersisted", (INBTBase)persistantTag);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (((Boolean)ConfigTombstone.general.handlePlayerXp.get()).booleanValue() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private static void storeSoulboundsOnBody(EntityPlayer player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        for (ItemStack key : keys) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)key.func_77946_l());
        }
        keys.clear();
        for (ItemStack soulbound : soulbounds) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)soulbound.func_77946_l());
        }
        soulbounds.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDrops(PlayerDropsEvent event) {
        boolean needAccess;
        IBlockState state;
        TileEntity tile;
        boolean hasDrop;
        if (!EntityHelper.isValidPlayer(event.getEntityPlayer()) || Helper.isRuleKeepInventory(event.getEntityPlayer())) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        WorldServer world = player.func_71121_q();
        if (event.isCanceled()) {
            ModTombstone.LOGGER.warn("The drop event of the player " + player.func_146103_bH().getName() + " was cancelled by another mod");
            return;
        }
        Iterator it = event.getDrops().iterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            EntityItem entityItem = (EntityItem)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d().func_77946_l();
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack);
                it.remove();
                continue;
            }
            if (!ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack);
            it.remove();
        }
        double range = ((Integer)ConfigTombstone.general.snifferRange.get()).intValue();
        List itemList = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range));
        it = itemList.listIterator();
        while (it.hasNext()) {
            EntityItem entityItem = (EntityItem)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d().func_77946_l();
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack);
                it.remove();
                continue;
            }
            if (!ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack);
            it.remove();
        }
        boolean bl = hasDrop = itemList.size() > 0 || event.getDrops().size() > 0;
        if (!((Boolean)ConfigTombstone.general.handlePlayerDeath.get()).booleanValue() || !hasDrop) {
            ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().orElse(ItemStack.field_190927_a));
            EventHandler.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            if (!hasDrop) {
                player.func_145747_a(LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            }
            return;
        }
        DeathHandler deathHandler = DeathHandler.instance;
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            player.func_145747_a(LangKey.MESSAGE_NO_GRAVE_LOCATION.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            EventHandler.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            return;
        }
        BlockPos initPos = Helper.getCloserValidPos((World)world, new BlockPos((Entity)player));
        boolean hasGrave = false;
        Location spawnPos = Location.ORIGIN;
        Location lastGrave = deathHandler.getLastGrave(player.func_200200_C_().func_150261_e());
        if (!lastGrave.isOrigin() && lastGrave.dim == Helper.getDimensionId((IWorld)world) && lastGrave.getPos().func_177951_i((Vec3i)initPos) <= 400.0 && (tile = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityGrave) {
            TileEntityGrave grave = (TileEntityGrave)tile;
            int emptySlots = (Integer)grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(graveInvent -> (int)IntStream.range(0, graveInvent.getSlots()).filter(slot -> graveInvent.getStackInSlot(slot).func_190926_b()).count()).orElse((Object)0);
            if (event.getDrops().size() <= emptySlots) {
                grave.resetDeathTime();
                grave.countTicks = 0;
                spawnPos = lastGrave;
                hasGrave = true;
            }
        }
        if (hasGrave) {
            Location finalPos = spawnPos;
            Optional<ItemStack> result = keys.stream().filter(p -> ModItems.grave_key.getTombPos((ItemStack)p).equals(finalPos) && !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst();
            result.ifPresent(itemStack -> ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, (ItemStack)itemStack));
        }
        if (!hasGrave && (spawnPos = new SpawnHelper(world, initPos).findSpawnPlace(true)).isOrigin()) {
            EventHandler.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            player.func_145747_a(LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            ModTombstone.LOGGER.info("There was nowhere to place the grave!");
            return;
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((EntityPlayer)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
            EnumFacing facing = player.func_174811_aO().func_176734_d();
            Block graveBlock = deathHandler.getFavoriteGraveBlock(player.func_110124_au());
            state = (IBlockState)((IBlockState)graveBlock.func_176223_P().func_206870_a((IProperty)BlockGraveBase.FACING, (Comparable)facing)).func_206870_a((IProperty)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true));
            Helper.placeNoEvent((World)world, spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        TileEntity tile2 = world.func_175625_s(spawnPos.getPos());
        if (!(tile2 instanceof TileEntityGrave)) {
            EventHandler.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
            player.func_145747_a(LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
            ModTombstone.LOGGER.info((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation());
            return;
        }
        TileEntityGrave grave = (TileEntityGrave)tile2;
        boolean bl2 = needAccess = (Boolean)ConfigTombstone.general.playerGraveAccess.get() != false && (Integer)ConfigTombstone.general.decayTime.get() != 0;
        if (needAccess && ((Boolean)ConfigTombstone.general.pvpMode.get()).booleanValue() && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            needAccess = false;
        }
        player.func_145747_a((hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, LangKey.MESSAGE_JOURNEYMAP.getTranslationWithStyle(StyleType.TOOLTIP_DESC, LangKey.MESSAGE_LAST_GRAVE.getTranslation(), spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim), LangKey.createComponentTranslationWithStyle((EntityPlayer)player, needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON, needAccess ? LangKey.MESSAGE_LOCKED : LangKey.MESSAGE_UNLOCKED, needAccess && (Integer)ConfigTombstone.general.decayTime.get() > 0 ? ConfigTombstone.general.decayTime.get() + " min" : "")));
        if (((Boolean)ConfigTombstone.general.playerGraveAccess.get()).booleanValue() || ((Boolean)ConfigTombstone.general.graveKeyOnDeath.get()).booleanValue()) {
            ItemStack key;
            if (hasGrave) {
                key = ItemStack.field_190927_a;
                for (ItemStack aKey : keys) {
                    if (!ModItems.grave_key.getTombPos(aKey).equals(spawnPos)) continue;
                    ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, aKey);
                    key = aKey;
                    break;
                }
                if (key.func_190926_b()) {
                    key = new ItemStack((IItemProvider)ModItems.grave_key);
                    ModItems.grave_key.setTombPos(key, spawnPos);
                    ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, key);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)key);
                }
            } else {
                key = new ItemStack((IItemProvider)ModItems.grave_key);
                ModItems.grave_key.setTombPos(key, spawnPos);
                ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, key);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)key);
            }
        }
        EventHandler.storeSoulboundsOnBody((EntityPlayer)player, keys, soulbounds);
        grave.setOwner((Entity)player, TimeHelper.systemTime(), needAccess);
        boolean hasLosses = Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.general.chanceLossOnDeath.get();
        int countLoss = 0;
        it = event.getDrops().iterator();
        while (it.hasNext()) {
            EntityItem entityItem = (EntityItem)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d().func_77946_l();
            if (hasLosses && stack.func_77985_e() && !stack.func_77942_o() && Helper.getRandom(1, 100) <= (Integer)ConfigTombstone.general.percentLossOnDeath.get()) {
                it.remove();
                ++countLoss;
                continue;
            }
            grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false));
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        if (countLoss > 0) {
            ItemStack junkStack = Helper.isDateAroundHalloween() ? new ItemStack((IItemProvider)ModItems.lollipop[world.field_73012_v.nextInt(ModItems.lollipop.length)], Helper.getRandom(1, 3)) : (countLoss > 5 ? new ItemStack((IItemProvider)ModItems.grave_dust) : (countLoss > 2 ? new ItemStack((IItemProvider)Items.field_151055_y) : new ItemStack((IItemProvider)Blocks.field_196555_aI)));
            grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)junkStack, (boolean)false));
            player.func_145747_a(LangKey.MESSAGE_LOSSES_ON_DEATH.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL));
        }
        for (EntityItem entityItem : itemList) {
            grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(itemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d(), (boolean)false));
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        Helper.grantAdvancement((EntityPlayer)player, "adventure/first_grave", new String[0]);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getName() == null || event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        if (event.getLeft().func_77973_b() instanceof ItemBlockGrave && event.getRight().func_77973_b() == Items.field_151042_j) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ItemBlockGrave.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                EventHandler.cancelAnvilRecipe(event);
            }
        } else if (ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && event.getRight().func_77973_b() == ModItems.grave_dust) {
            ItemStack output = event.getLeft().func_77946_l();
            if (ModItems.tablet_of_assistance.setEngravedName(output, event.getName())) {
                event.setCost(2);
                event.setOutput(output);
                event.setMaterialCost(1);
            } else {
                EventHandler.cancelAnvilRecipe(event);
            }
        }
    }

    private static void cancelAnvilRecipe(AnvilUpdateEvent event) {
        event.setCost(0);
        event.setMaterialCost(0);
        event.setOutput(ItemStack.field_190927_a);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (event.getItemInput().func_77973_b() instanceof ItemBlockGrave && event.getIngredientInput().func_77973_b() == Items.field_151042_j && ItemBlockGrave.isEngraved(event.getItemResult())) {
            Helper.grantAdvancement(event.getEntityPlayer(), "adventure/engrave_decorative_grave", new String[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void uncancelGraveRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block instanceof BlockGrave) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().field_72995_K && SpawnProtectionHandler.getInstance().isBlockProtected(Helper.getDimensionId((IWorld)event.getWorld()), event.getPos())) {
                PacketHandler.sendToServer(new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onUpdateShadowStep(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K || !ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() || !((Boolean)ConfigTombstone.client.showShadowStep.get()).booleanValue() || ConfigTombstone.enchantments.isNerfShadowStep() && !event.getEntity().func_70093_af()) {
            return;
        }
        if (EntityHelper.hasEnchantment(event.getEntityLiving(), ModEnchantments.shadow_step)) {
            ModTombstone.PROXY.produceShadowStep(event.getEntityLiving(), 115.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getEntityLiving())) {
            int bonus = EntityHelper.getPerkLevelWithBonus((EntityPlayer)event.getEntityLiving(), ModPerks.alchemist);
            event.getPotionEffect().field_76460_b = (int)((double)event.getPotionEffect().field_76460_b * (1.0 + (double)bonus / 10.0));
        }
    }
}

