/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GuiInfo
extends GuiScreen {
    private static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("tombstone", "textures/gui/knowledge.png");
    private final int guiWidth = 166;
    private final int guiHeight = 166;
    private int posX;
    private int posY;
    @Nullable
    private Info currentInfo;
    @Nullable
    private Info lastInfo;
    @Nullable
    private Info hoveredInfo = null;
    private int linesByPage;
    private int pageCount;
    private int currentPage;
    private String title;
    private final List<String> contentLines = new ArrayList<String>();
    private final List<InfoLink> infoLinks = new ArrayList<InfoLink>();
    private final float scaled;
    private final float scaledRev;

    GuiInfo(@Nullable Info currentInfo) {
        this.currentInfo = this.lastInfo = currentInfo;
        this.currentPage = 0;
        this.scaled = Minecraft.func_71410_x().field_71474_y.field_74335_Z == 1 ? 1.0f : 2.0f;
        this.scaledRev = 1.0f / this.scaled;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (GuiButton button : this.field_146292_n) {
            if (!button.field_146124_l || !button.field_146125_m || !(mouseX >= (double)button.field_146128_h) || !(mouseY >= (double)button.field_146129_i) || !(mouseX <= (double)(button.field_146128_h + button.field_146120_f) & mouseY <= (double)(button.field_146129_i + button.field_146121_g))) continue;
            this.actionPerformed(button);
            this.updateButtons();
            return true;
        }
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.currentInfo = this.hoveredInfo;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ((Object)((Object)this)).getClass();
        this.posX = (this.field_146294_l - 166) / 2;
        ((Object)((Object)this)).getClass();
        this.posY = (this.field_146295_m - 166) / 2;
        int centerPos = this.field_146294_l / 2;
        this.field_146292_n.add(new TBGuiButton(0, centerPos - 35, this.posY + 140, 70, 15, LangKey.MESSAGE_BACK.getClientTranslation(new Object[0])));
        this.field_146292_n.add(new TBGuiButton(1, centerPos - 75, this.posY + 140, 20, 15, LangKey.getClientTranslation("<-", new Object[0])));
        this.field_146292_n.add(new TBGuiButton(2, centerPos + 55, this.posY + 140, 20, 15, LangKey.getClientTranslation("->", new Object[0])));
        this.updatePage(this.currentInfo);
    }

    private void updateContent(@Nullable Info currentInfo) {
        List<Info> infos;
        this.contentLines.clear();
        this.infoLinks.clear();
        String content = LangKey.getClientTranslation(currentInfo == null ? "tombstone.compendium.main.desc" : currentInfo.getContent(), new Object[0]);
        Arrays.stream(content.split("[\\r\\n]+")).filter(p -> p.length() > 0).forEach(c -> {
            ((Object)((Object)this)).getClass();
            this.contentLines.addAll(this.field_146289_q.func_78271_c(c, (int)((float)(166 - 15) * this.scaled)));
        });
        ((Object)((Object)this)).getClass();
        int x = this.posX + 166 + 5;
        int y = this.posY + 10;
        if (currentInfo == null) {
            infos = Arrays.stream(Info.values()).filter(p -> ((Info)p).isMainEntry).collect(Collectors.toList());
        } else {
            infos = Info.getRelated(currentInfo);
            infos.sort(Comparator.comparing(p -> Normalizer.normalize(LangKey.getClientTranslation(p.getTitle(), new Object[0]), Normalizer.Form.NFD)));
        }
        for (Info info : infos) {
            this.infoLinks.add(new InfoLink(info, x, y));
            y += this.field_146289_q.field_78288_b / (int)this.scaled + 1;
        }
    }

    private void updatePage(@Nullable Info currentInfo) {
        this.lastInfo = currentInfo;
        this.title = LangKey.getClientTranslation(currentInfo == null ? "tombstone.compendium.main.title" : currentInfo.getTitle(), new Object[0]);
        this.updateContent(currentInfo);
        this.linesByPage = (int)Math.floor(9.0f * this.scaled);
        this.pageCount = (int)Math.ceil((float)this.contentLines.size() / (float)this.linesByPage);
        this.currentPage = 0;
        this.updateButtons();
    }

    private void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = this.currentPage > 0;
        ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage < this.pageCount - 1;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m;
    }

    private void actionPerformed(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.currentInfo == null) {
                    this.field_146297_k.field_71439_g.func_71053_j();
                    break;
                }
                this.currentInfo = null;
                break;
            }
            case 1: {
                --this.currentPage;
                this.updateButtons();
                break;
            }
            case 2: {
                ++this.currentPage;
                this.updateButtons();
                break;
            }
        }
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        int borderColor = -15524569;
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        GuiInfo.func_73734_a((int)(this.posX - 3), (int)(this.posY - 3), (int)(this.posX + 166 + 3), (int)(this.posY + 166 + 3), (int)borderColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GUI_BACKGROUND);
        GuiInfo.func_146110_a((int)this.posX, (int)this.posY, (float)0.0f, (float)0.0f, (int)166, (int)166, (float)166.0f, (float)166.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        this.hoveredInfo = null;
        if (this.currentInfo != this.lastInfo) {
            this.updatePage(this.currentInfo);
        }
        ((Object)((Object)this)).getClass();
        GuiInfo.func_73734_a((int)(this.posX + 5), (int)(this.posY + 5), (int)(this.posX + 166 - 5), (int)(this.posY + 20 + this.field_146289_q.field_78288_b), (int)0x55000000);
        this.field_146289_q.func_211126_b(this.title, (float)(this.posX + 30), (float)(this.posY + 15), -7769547);
        if (this.currentInfo != null) {
            GlStateManager.func_179139_a((double)this.scaledRev, (double)this.scaledRev, (double)this.scaledRev);
            String string = this.currentPage + 1 + "/" + this.pageCount;
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_211126_b(string, (float)(this.posX + 166) * this.scaled - 30.0f, (float)(this.posY + 6) * this.scaled, -7769547);
            GlStateManager.func_179139_a((double)this.scaled, (double)this.scaled, (double)this.scaled);
        }
        if (this.currentInfo == null) {
            GuiInfo.func_73734_a((int)(this.posX + 7), (int)(this.posY + 7), (int)(this.posX + 18 + this.field_146289_q.field_78288_b), (int)(this.posY + 18 + this.field_146289_q.field_78288_b), (int)-9790778);
            this.field_146296_j.func_180450_b(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)GraveModel.TOMBSTONE)), (int)((float)(this.posX + 9) / 1.0f), (int)((float)(this.posY + 9) / 1.0f));
        } else if (!this.currentInfo.icon.func_190926_b()) {
            GuiInfo.func_73734_a((int)(this.posX + 7), (int)(this.posY + 7), (int)(this.posX + 18 + this.field_146289_q.field_78288_b), (int)(this.posY + 18 + this.field_146289_q.field_78288_b), (int)-9790778);
            this.field_146296_j.func_180450_b(this.currentInfo.icon, (int)((float)(this.posX + 9) / 1.0f), (int)((float)(this.posY + 9) / 1.0f));
        }
        GlStateManager.func_179139_a((double)this.scaledRev, (double)this.scaledRev, (double)this.scaledRev);
        int indexStart = Math.min(this.currentPage * this.linesByPage, this.contentLines.size() - 1);
        int indexEnd = Math.min(indexStart + this.linesByPage - 1, this.contentLines.size() - 1);
        if (indexStart >= 0) {
            int n = (int)((float)(this.posX + 5) * this.scaled);
            int n2 = (int)((float)(this.posY + 34) * this.scaled);
            ((Object)((Object)this)).getClass();
            GuiInfo.func_73734_a((int)n, (int)n2, (int)((int)((float)(this.posX + 166 - 5) * this.scaled)), (int)((int)((float)(this.posY + 44 + (this.field_146289_q.field_78288_b / (int)this.scaled + 1) * (indexEnd - indexStart + 1)) * this.scaled)), (int)0x55000000);
            int count = 0;
            for (int i = indexStart; i <= indexEnd; ++i) {
                this.field_146289_q.func_211126_b(this.contentLines.get(i), (float)(this.posX + 10) * this.scaled, (float)(this.posY + 39 + count * (this.field_146289_q.field_78288_b / (int)this.scaled + 1)) * this.scaled, -7769547);
                ++count;
            }
        }
        for (InfoLink link : this.infoLinks) {
            if (this.hoveredInfo == null && link.isHovered(mouseX, mouseY)) {
                this.hoveredInfo = link.info;
                this.field_146289_q.func_211126_b(link.title, (float)link.x * this.scaled, (float)link.y * this.scaled, -1);
                continue;
            }
            this.field_146289_q.func_211126_b(link.title, (float)link.x * this.scaled, (float)link.y * this.scaled, -7769547);
        }
        GlStateManager.func_179139_a((double)this.scaled, (double)this.scaled, (double)this.scaled);
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public boolean func_73868_f() {
        return true;
    }

    static enum Info {
        DEATH(new ItemStack((IItemProvider)ModItems.advancement[0]), true),
        DECORATIVE_GRAVE(new ItemStack((IItemProvider)ModBlocks.decorative_graves.get((Object)((Object)GraveModel.GRAVE_SIMPLE))), true, "tombstone.config_cat.decorative_grave"),
        MAGIC_ITEMS(new ItemStack((IItemProvider)ModItems.advancement[2]), true),
        KNOWLEDGE_OF_DEATH(new ItemStack((IItemProvider)ModItems.ankh_of_pray), true, "tombstone.message.knowledge_of_death"),
        SPECIAL_BONUS(ItemStack.field_190927_a, true),
        ANKH_OF_PRAY(new ItemStack((IItemProvider)ModItems.ankh_of_pray), false, "tombstone.item.ankh_of_pray"),
        BOOK_OF_DISENCHANTMENT(new ItemStack((IItemProvider)ModItems.book_of_disenchantment), false, "tombstone.item.book_of_disenchantment"),
        CONTRIBUTOR(ItemStack.field_190927_a, false),
        DARK_MARBLE(new ItemStack((IItemProvider)ModBlocks.dark_marble), false, "tombstone.block.dark_marble"),
        DUST_OF_VANISHING(new ItemStack((IItemProvider)ModItems.dust_of_vanishing), false, "tombstone.item.dust_of_vanishing"),
        FISHING_ROD_OF_MISADVENTURE(new ItemStack((IItemProvider)ModItems.fishing_rod_of_misadventure), false, "tombstone.item.fishing_rod_of_misadventure"),
        GHOSTLY_SHAPE(new ItemStack((IItemProvider)ModItems.advancement[1]), false, "tombstone.potion.ghostly_shape"),
        GRAVE_DUST(new ItemStack((IItemProvider)ModItems.grave_dust), false, "tombstone.item.grave_dust"),
        GRAVE_KEY(new ItemStack((IItemProvider)ModItems.grave_key), false, "tombstone.item.grave_key"),
        HALLOWEEN(new ItemStack((IItemProvider)ModItems.advancement[6]), false),
        LOLLIPOP(new ItemStack((IItemProvider)ModItems.lollipop[0]), false, "tombstone.item.lollipop"),
        LOST_TABLET(new ItemStack((IItemProvider)ModItems.lost_tablet), false, "tombstone.item.lost_tablet"),
        PERK(ItemStack.field_190927_a, false),
        SCROLL_OF_FEATHER_FALL(new ItemStack((IItemProvider)ModItems.scroll_buff[2]), false, "tombstone.item.scroll_of_feather_fall"),
        SCROLL_OF_KNOWLEDGE(new ItemStack((IItemProvider)ModItems.scroll_of_knowledge), false, "tombstone.item.scroll_of_knowledge"),
        SCROLL_OF_PRESERVATION(new ItemStack((IItemProvider)ModItems.scroll_buff[0]), false, "tombstone.item.scroll_of_preservation"),
        SCROLL_OF_PURIFICATION(new ItemStack((IItemProvider)ModItems.scroll_buff[3]), false, "tombstone.item.scroll_of_purification"),
        SCROLL_OF_TRUE_SIGHT(new ItemStack((IItemProvider)ModItems.scroll_buff[4]), false, "tombstone.item.scroll_of_true_sight"),
        SCROLL_OF_UNSTABLE_INTANGIBLENESS(new ItemStack((IItemProvider)ModItems.scroll_buff[1]), false, "tombstone.item.scroll_of_unstable_intangibleness"),
        MAGIC_SCROLLS(new ItemStack((IItemProvider)ModItems.strange_scroll), false),
        SOUL(new ItemStack((IItemProvider)ModItems.advancement[5]), false),
        SOUL_RECEPTACLE(new ItemStack((IItemProvider)ModItems.soul_receptacle), false, "tombstone.item.soul_receptacle"),
        STRANGE_SCROLL(new ItemStack((IItemProvider)ModItems.strange_scroll), false, "tombstone.item.strange_scroll"),
        STRANGE_TABLET(new ItemStack((IItemProvider)ModItems.strange_tablet), false, "tombstone.item.strange_tablet"),
        TABLET_OF_RECALL(new ItemStack((IItemProvider)ModItems.tablet_of_recall), false, "tombstone.item.tablet_of_recall"),
        TABLET_OF_ASSISTANCE(new ItemStack((IItemProvider)ModItems.tablet_of_assistance), false, "tombstone.item.tablet_of_assistance"),
        MAGIC_TABLETS(new ItemStack((IItemProvider)ModItems.strange_tablet), false),
        VOODOO_POPPET(new ItemStack((IItemProvider)ModItems.voodoo_poppet), false, "tombstone.item.voodoo_poppet");

        private final ItemStack icon;
        private final boolean isMainEntry;
        private final String title;

        private Info(ItemStack icon, boolean isMainEntry) {
            this(icon, isMainEntry, null);
        }

        private Info(@Nullable ItemStack icon, boolean isMainEntry, String titleKey) {
            this.icon = icon;
            this.isMainEntry = isMainEntry;
            this.title = titleKey == null ? "tombstone.compendium." + this.name().toLowerCase() + ".title" : titleKey;
        }

        public final String getTitle() {
            return this.title;
        }

        public final String getContent() {
            return "tombstone.compendium." + this.name().toLowerCase() + ".desc";
        }

        public static List<Info> getRelated(Info info) {
            ArrayList<Info> infos = new ArrayList<Info>();
            switch (info) {
                case ANKH_OF_PRAY: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case BOOK_OF_DISENCHANTMENT: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case CONTRIBUTOR: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case DARK_MARBLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(GRAVE_DUST);
                    break;
                }
                case DEATH: {
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(GRAVE_KEY);
                    infos.add(PERK);
                    break;
                }
                case DECORATIVE_GRAVE: {
                    infos.add(DARK_MARBLE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case DUST_OF_VANISHING: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case FISHING_ROD_OF_MISADVENTURE: {
                    infos.add(LOST_TABLET);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case GHOSTLY_SHAPE: {
                    infos.add(DEATH);
                    break;
                }
                case GRAVE_DUST: {
                    infos.add(DARK_MARBLE);
                    infos.add(DUST_OF_VANISHING);
                    break;
                }
                case GRAVE_KEY: {
                    infos.add(DEATH);
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case HALLOWEEN: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case KNOWLEDGE_OF_DEATH: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(SOUL);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case LOLLIPOP: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case LOST_TABLET: {
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case MAGIC_ITEMS: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(BOOK_OF_DISENCHANTMENT);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(GRAVE_KEY);
                    infos.add(LOLLIPOP);
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL_RECEPTACLE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(VOODOO_POPPET);
                    break;
                }
                case MAGIC_SCROLLS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(SCROLL_OF_FEATHER_FALL);
                    infos.add(SCROLL_OF_KNOWLEDGE);
                    infos.add(SCROLL_OF_PRESERVATION);
                    infos.add(SCROLL_OF_PURIFICATION);
                    infos.add(SCROLL_OF_TRUE_SIGHT);
                    infos.add(SCROLL_OF_UNSTABLE_INTANGIBLENESS);
                    infos.add(SOUL);
                    infos.add(STRANGE_SCROLL);
                    break;
                }
                case STRANGE_SCROLL: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_SCROLLS);
                    break;
                }
                case STRANGE_TABLET: {
                    infos.add(DARK_MARBLE);
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_TABLETS);
                    break;
                }
                case MAGIC_TABLETS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(LOST_TABLET);
                    infos.add(SOUL);
                    infos.add(STRANGE_TABLET);
                    infos.add(TABLET_OF_ASSISTANCE);
                    infos.add(TABLET_OF_RECALL);
                    break;
                }
                case PERK: {
                    infos.add(DEATH);
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case SCROLL_OF_FEATHER_FALL: 
                case SCROLL_OF_KNOWLEDGE: 
                case SCROLL_OF_PRESERVATION: 
                case SCROLL_OF_PURIFICATION: 
                case SCROLL_OF_TRUE_SIGHT: 
                case SCROLL_OF_UNSTABLE_INTANGIBLENESS: {
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL);
                    break;
                }
                case SOUL: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case SOUL_RECEPTACLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case SPECIAL_BONUS: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    break;
                }
                case TABLET_OF_ASSISTANCE: 
                case TABLET_OF_RECALL: {
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL);
                    break;
                }
                case VOODOO_POPPET: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                }
            }
            return infos;
        }
    }

    public class InfoLink {
        private final String title;
        private final Info info;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        InfoLink(Info info, int x, int y) {
            this.title = I18n.func_135052_a((String)info.getTitle(), (Object[])new Object[0]);
            this.info = info;
            this.x = x;
            this.y = y;
            this.width = GuiInfo.this.field_146289_q.func_78256_a(this.title) / (int)GuiInfo.this.scaled;
            this.height = ((GuiInfo)GuiInfo.this).field_146289_q.field_78288_b / (int)GuiInfo.this.scaled + 1;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width & mouseY <= this.y + this.height;
        }
    }
}

