/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.Queues;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CallbackHandler {
    private static final Queue<DelayedCallback> callbacks = Queues.newConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<DelayedCallback> getDelayedQueue() {
        Queue<DelayedCallback> queue = callbacks;
        synchronized (queue) {
            return callbacks;
        }
    }

    public static void addCallback(int delay, Runnable callback) {
        CallbackHandler.getDelayedQueue().add(new DelayedCallback(delay, callback));
    }

    public static void clear() {
        CallbackHandler.getDelayedQueue().clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            Queue<DelayedCallback> callbacks = CallbackHandler.getDelayedQueue();
            if (callbacks.isEmpty()) {
                return;
            }
            HashSet toRemove = new HashSet();
            callbacks.forEach(callback -> {
                if (callback.delay.getAndDecrement() <= 0) {
                    callback.task.run();
                    toRemove.add(callback);
                }
            });
            callbacks.removeAll(toRemove);
        }
    }

    public static class DelayedCallback {
        final AtomicInteger delay;
        final Runnable task;

        DelayedCallback(int delay, Runnable task) {
            this.delay = new AtomicInteger(delay);
            this.task = task;
        }
    }
}

