/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

public class DeathHandler {
    public static final DeathHandler instance = new DeathHandler();
    private final HashMap<UUID, GraveModel> optionFavoriteGrave = new HashMap();
    private final HashMap<UUID, Boolean> optionEquipElytraInPriority = new HashMap();
    private final HashMap<UUID, Boolean> optionKnowledgeMessage = new HashMap();
    private final HashMap<UUID, List<PotionEffect>> playerDeadList = new HashMap();
    private final HashMap<String, Location> lastGraveList = new HashMap();

    private DeathHandler() {
    }

    public Location getLastGrave(String playerName) {
        return this.lastGraveList.getOrDefault(playerName, Location.ORIGIN);
    }

    public void removeGrave(Location pos) {
        Iterator<Map.Entry<String, Location>> it = this.lastGraveList.entrySet().iterator();
        while (it.hasNext()) {
            Location gravePos = it.next().getValue();
            if (!gravePos.equals(pos)) continue;
            it.remove();
        }
    }

    public void logLastGrave(@Nullable EntityPlayer player, int x, int y, int z, int dim) {
        if (player == null) {
            return;
        }
        this.lastGraveList.put(player.func_146103_bH().getName(), new Location(x, y, z, dim));
        if (((Boolean)ConfigTombstone.general.logPlayerGrave.get()).booleanValue()) {
            ModTombstone.LOGGER.info("A new grave of the player " + player.func_146103_bH().getName() + " was created at position [x:" + x + ", y:" + y + ", z:" + z + ", dim:" + dim + "]");
        }
    }

    public boolean isNoGraveLocation(Location location) {
        for (String s : (List)ConfigTombstone.general.noGraveLocation.get()) {
            String[] res;
            if (s.isEmpty() || !((res = s.split(",")).length == 5 ? new Location(Integer.valueOf(res[0].trim()), Integer.valueOf(res[1].trim()), Integer.valueOf(res[2].trim()), Integer.valueOf(res[3].trim())).isInRangeAndDimension(location, Integer.valueOf(res[4].trim())) : res.length == 1 && location.dim == Integer.valueOf(res[0].trim()))) continue;
            return true;
        }
        return false;
    }

    public void addPlayerDead(EntityPlayer player) {
        UUID playerUUID = player.func_110124_au();
        ArrayList<PotionEffect> effectsList = new ArrayList<PotionEffect>();
        if (((Boolean)ConfigTombstone.general.restoreEffectsOnDeath.get()).booleanValue() || EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation)) {
            for (PotionEffect effect : player.func_70651_bq()) {
                if (!this.isAllowedEffect(effect)) continue;
                effectsList.add(effect);
            }
        }
        this.playerDeadList.put(playerUUID, effectsList);
    }

    public boolean isAllowedEffect(PotionEffect effect) {
        assert (effect.func_188419_a().getRegistryName() != null);
        return !effect.func_188419_a().func_76398_f() && !((List)ConfigTombstone.general.blackListEffects.get()).contains(effect.func_188419_a().getRegistryName().toString());
    }

    public void restorePlayerDead(EntityPlayer player) {
        if (!this.isPlayerDead(player)) {
            return;
        }
        if (!Helper.isDisabledPerk(player, ModPerks.ghostly_shape)) {
            EntityHelper.addPotion((EntityLivingBase)player, ModEffects.ghostly_shape, (Integer)ConfigTombstone.general.ghostlyShapeDuration.get() * 20, EntityHelper.getPerkLevelWithBonus(player, ModPerks.ghostly_shape), new boolean[0]);
        }
        UUID playerUUID = player.func_110124_au();
        if (((Boolean)ConfigTombstone.general.restoreEffectsOnDeath.get()).booleanValue() || EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation)) {
            List<PotionEffect> effectsList = this.playerDeadList.get(playerUUID);
            for (PotionEffect effect : effectsList) {
                if (!this.isAllowedEffect(effect)) continue;
                PotionEffect activeEffect = player.func_70660_b(effect.func_188419_a());
                if (activeEffect != null) {
                    if (activeEffect.func_76459_b() >= effect.func_76459_b()) continue;
                    player.func_195063_d(activeEffect.func_188419_a());
                }
                player.func_195064_c(effect);
            }
        }
        this.playerDeadList.remove(playerUUID);
    }

    public boolean isPlayerDead(EntityPlayer player) {
        return this.playerDeadList.containsKey(player.func_110124_au());
    }

    public DeathHandler setOptionFavoriteGrave(UUID id, @Nullable GraveModel graveType) {
        this.optionFavoriteGrave.put(id, graveType != null ? graveType : GraveModel.getDefaultGrave());
        return this;
    }

    public GraveModel getFavoriteGraveModel(UUID id) {
        return this.optionFavoriteGrave.getOrDefault(id, GraveModel.getDefaultGrave());
    }

    public Block getFavoriteGraveBlock(UUID id) {
        switch (this.getFavoriteGraveModel(id)) {
            case GRAVE_CROSS: {
                return ModBlocks.graves.get((Object)GraveModel.GRAVE_CROSS);
            }
            case GRAVE_NORMAL: {
                return ModBlocks.graves.get((Object)GraveModel.GRAVE_NORMAL);
            }
            case TOMBSTONE: {
                return ModBlocks.graves.get((Object)GraveModel.TOMBSTONE);
            }
        }
        return ModBlocks.graves.get((Object)GraveModel.GRAVE_SIMPLE);
    }

    public DeathHandler setOptionEquipElytraInPriority(UUID id, boolean value) {
        this.optionEquipElytraInPriority.put(id, value);
        return this;
    }

    public boolean getOptionEquipElytraInPriority(UUID id) {
        return this.optionEquipElytraInPriority.getOrDefault(id, false);
    }

    public DeathHandler setOptionKnowledgeMessage(UUID id, boolean value) {
        this.optionKnowledgeMessage.put(id, value);
        return this;
    }

    public boolean getOptionKnowledgeMessage(UUID id) {
        return this.optionKnowledgeMessage.getOrDefault(id, true);
    }

    public void handleMobDrops(EntityLivingBase entity, @Nullable DamageSource damageSource, Collection<EntityItem> drops) {
        EntityPlayerMP player;
        EntityPlayerMP entityPlayerMP = player = damageSource != null && EntityHelper.isValidPlayerMP(damageSource.func_76346_g()) ? (EntityPlayerMP)damageSource.func_76346_g() : null;
        if (entity.func_70662_br()) {
            int chanceModifier = EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.bone_collector) * 100;
            if (Helper.getRandom(1, 1000 - chanceModifier) <= (Integer)ConfigTombstone.loot.chanceGraveDust.get() + chanceModifier) {
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.grave_dust, Helper.getRandom(1, 2))));
            }
            if (((Boolean)ConfigTombstone.loot.undeadCanDropSkull.get()).booleanValue() && (entity instanceof EntitySkeleton || entity instanceof EntityZombie) && Helper.getRandom(1, 1000 - chanceModifier) <= 5) {
                ItemStack skullStack = new ItemStack((IItemProvider)(entity instanceof EntitySkeleton ? Items.field_196182_dv : Items.field_196186_dz));
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, skullStack));
            }
            if (!entity.func_184222_aU()) {
                ItemStack stack;
                if ((Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceSoulReceptacleOnBoss.get()) {
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.soul_receptacle)));
                }
                if ((Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceRandomScrollOnBoss.get()) {
                    stack = new ItemStack((IItemProvider)ModItems.scroll_buff[ItemScrollBuff.SpellBuff.getRandomBuff().ordinal()], 1);
                    NBTStackHelper.setBoolean(stack, "enchant", true);
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                }
                if ((Integer)ConfigTombstone.loot.chanceRandomPoppetOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceRandomPoppetOnBoss.get()) {
                    stack = new ItemStack((IItemProvider)ModItems.voodoo_poppet);
                    ModItems.voodoo_poppet.addProtection(stack, ItemVoodooPoppet.PoppetProtections.getRandomProtection());
                    NBTStackHelper.setBoolean(stack, "enchant", true);
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                }
                if (player != null && (Integer)ConfigTombstone.loot.chanceDecorativeGraveOnBoss.get() > 0 && Helper.getRandom(1, 1000 - chanceModifier) < (Integer)ConfigTombstone.loot.chanceDecorativeGraveOnBoss.get()) {
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)this.getFavoriteGraveBlock(player.func_110124_au()))));
                }
            }
        }
        if (entity instanceof EntityMob && player != null && (Helper.isContributor((EntityPlayer)player) || Helper.isDateAroundHalloween()) && Helper.getRandom(1, 1000) <= 100) {
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.lollipop[player.field_70170_p.field_73012_v.nextInt(ModItems.lollipop.length)], 1)));
        }
    }

    public void clear() {
        this.optionFavoriteGrave.clear();
        this.optionEquipElytraInPriority.clear();
        this.optionKnowledgeMessage.clear();
        this.playerDeadList.clear();
        this.lastGraveList.clear();
    }
}

