/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.util.FakePlayer;
import ovh.corail.tombstone.capability.ITBCapability;
import ovh.corail.tombstone.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;

public class EntityHelper {
    public static boolean hasEnchantment(EntityLivingBase entity, Enchantment ench) {
        return EntityHelper.hasEnchantment(entity, ench, 1);
    }

    public static boolean hasEnchantment(EntityLivingBase entity, Enchantment ench, int lvl) {
        for (ItemStack stack : ench.func_185260_a(entity)) {
            if (EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) < lvl) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(EntityLivingBase entity, Enchantment ench) {
        int lvl = 0;
        for (ItemStack stack : ench.func_185260_a(entity)) {
            int currentLvl = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack);
            if (currentLvl <= lvl) continue;
            lvl = currentLvl;
        }
        return lvl;
    }

    public static boolean isValidPlayer(@Nullable ICommandSource sender) {
        return sender instanceof EntityPlayer && !(sender instanceof FakePlayer);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof EntityPlayer && !(entity instanceof FakePlayer);
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static boolean isValidPlayer(@Nullable EntityPlayer player) {
        return player != null && !(player instanceof FakePlayer);
    }

    public static boolean isSurvivalPlayer(@Nullable EntityPlayer player) {
        return EntityHelper.isValidPlayer(player) && !player.func_184812_l_() && !player.func_175149_v();
    }

    public static void setPlayerXp(EntityPlayer player, int amount) {
        if (amount < 0) {
            return;
        }
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
        player.field_71106_cc += (float)amount / (float)player.func_71050_bK();
        player.field_71067_cb += amount;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ++player.field_71068_ca;
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static int getPlayerTotalXp(EntityPlayer player) {
        return EntityHelper.getPlayerTotalXp(player.field_71068_ca, player.field_71106_cc);
    }

    public static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal;
        if (level < 17) {
            experienceTotal = level * level + 6 * level;
            experienceTotal = (int)((float)experienceTotal + (float)(2 * level + 7) * bar);
        } else if (level < 32) {
            experienceTotal = (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
            experienceTotal = (int)((float)experienceTotal + (float)(5 * level - 38) * bar);
        } else {
            experienceTotal = (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
            experienceTotal = (int)((float)experienceTotal + (float)(9 * level - 158) * bar);
        }
        return experienceTotal;
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static void addPotion(@Nullable EntityLivingBase entity, @Nullable Potion potion, int duration) {
        EntityHelper.addPotion(entity, potion, duration, 0, new boolean[0]);
    }

    public static void addPotion(@Nullable EntityLivingBase entity, @Nullable Potion potion, int duration, int amplifier, boolean ... params) {
        if (entity == null || potion == null) {
            return;
        }
        entity.func_195064_c(new PotionEffect(potion, duration, amplifier, params.length <= 0 || params[0], params.length <= 1 || params[1]));
    }

    public static boolean isPotionActive(EntityLivingBase entity, Potion potion) {
        return EntityHelper.getPotionDuration(entity, potion) > 0;
    }

    public static int getPotionDuration(@Nullable EntityLivingBase entity, @Nullable Potion potion) {
        if (entity == null || potion == null) {
            return 0;
        }
        PotionEffect effect = entity.func_70660_b(potion);
        if (effect == null) {
            return 0;
        }
        if (effect.func_76459_b() > 0) {
            return effect.func_76459_b();
        }
        entity.func_195063_d(potion);
        return 0;
    }

    public static boolean isPotionActive(@Nullable EntityLivingBase entity, @Nullable Potion potion, int amplifier) {
        if (entity == null || potion == null) {
            return false;
        }
        PotionEffect effect = entity.func_70660_b(potion);
        if (effect == null || effect.func_76458_c() < amplifier) {
            return false;
        }
        if (effect.func_76459_b() > 0) {
            return true;
        }
        entity.func_195063_d(potion);
        return false;
    }

    public static boolean isPotionHidden(@Nullable EntityLivingBase entity, @Nullable Potion potion) {
        if (entity == null || potion == null) {
            return false;
        }
        PotionEffect effect = entity.func_70660_b(potion);
        return effect != null && effect.func_82720_e() && !effect.func_188418_e();
    }

    public static void capPotionDuration(EntityLivingBase entity, Potion potion, int maxDuration) {
        if (EntityHelper.getPotionDuration(entity, potion) > maxDuration) {
            entity.func_195063_d(potion);
            EntityHelper.addPotion(entity, potion, maxDuration);
        }
    }

    public static void clearBadEffects(@Nullable EntityLivingBase entity) {
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            Iterator it = entity.func_70651_bq().iterator();
            while (it.hasNext()) {
                PotionEffect effect = (PotionEffect)it.next();
                if (!effect.func_188419_a().func_76398_f()) continue;
                entity.field_70752_e = true;
                effect.func_188419_a().func_111187_a(entity, entity.func_110140_aT(), effect.func_76458_c());
                it.remove();
            }
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
        }
    }

    public static boolean hasCooldown(@Nullable EntityPlayer player, Item item) {
        return EntityHelper.getCooldown(player, item) != 0.0f;
    }

    public static boolean hasCooldown(@Nullable EntityPlayer player, ItemStack stack) {
        return EntityHelper.hasCooldown(player, stack.func_77973_b());
    }

    public static void setCooldown(EntityPlayer player, Item item, int ticks) {
        player.func_184811_cZ().func_185145_a(item, ticks);
    }

    public static void setCooldown(EntityPlayer player, ItemStack stack, int ticks) {
        EntityHelper.setCooldown(player, stack.func_77973_b(), ticks);
    }

    public static float getCooldown(@Nullable EntityPlayer player, Item item) {
        return player != null ? player.func_184811_cZ().func_185143_a(item, 0.0f) : 0.0f;
    }

    public static long getKnowledge(EntityPlayer player) {
        return (Long)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(ITBCapability::getKnowledge).orElse((Object)0L);
    }

    public static void addKnowledge(EntityPlayerMP player, long points) {
        if (points > 0L) {
            player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                int oldPerkPoints = cap.getTotalPerkPoints();
                cap.addKnowledge(points);
                if (DeathHandler.instance.getOptionKnowledgeMessage(player.func_110124_au())) {
                    player.func_145747_a(LangKey.MESSAGE_EARN_KNOWLEDGE.getTranslationWithStyle(StyleType.MESSAGE_SPELL, LangKey.MESSAGE_YOU.getTranslation(), points));
                    int adjust = cap.getTotalPerkPoints() - oldPerkPoints;
                    if (adjust > 0) {
                        player.func_145747_a(LangKey.MESSAGE_ACCESS_GUI.getTranslationWithStyle(StyleType.MESSAGE_SPECIAL, adjust, LangKey.createComponentCommand((EntityPlayer)player, "/tbgui", LangKey.MESSAGE_HERE, new Object[0])));
                    }
                }
                Helper.grantAdvancement((EntityPlayer)player, "adventure/first_knowledge", new String[0]);
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, cap.getKnowledge()), player);
            });
        }
    }

    public static void removeKnowledge(EntityPlayerMP player, int amount) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
            int oldPerkPoints = cap.getTotalPerkPoints();
            cap.setKnowledge(Math.max(0L, cap.getKnowledge() - (long)amount));
            int lostPerkPoints = oldPerkPoints - cap.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                HashMap<Perk, Integer> perks = cap.getPerks();
                Iterator<Map.Entry<Perk, Integer>> it = perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk((EntityPlayer)player, entry.getKey())) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, cap.getKnowledge(), cap.getNextPray(), perks), player);
            } else {
                PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, cap.getKnowledge()), player);
            }
            if (DeathHandler.instance.getOptionKnowledgeMessage(player.func_110124_au())) {
                player.func_145747_a(LangKey.MESSAGE_LOSE_KNOWLEDGE.getTranslationWithStyle(StyleType.MESSAGE_SPELL, LangKey.MESSAGE_YOU.getTranslation(), amount));
            }
        });
    }

    public static int getPerkLevelWithBonus(@Nullable EntityPlayer player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !Helper.isDisabledPerk(player, perk)) {
            return (Integer)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> Math.min(cap.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax())).orElse((Object)0);
        }
        return 0;
    }

    public static boolean canPray(@Nullable EntityPlayer player) {
        return EntityHelper.isValidPlayer(player) && (Boolean)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).map(cap -> cap.canPray(player)).orElse((Object)false) != false;
    }

    public static void syncTBCapability(EntityPlayerMP player) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> PacketHandler.sendToPlayer(new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, cap.getKnowledge(), cap.getNextPray(), cap.getPerks()), player));
    }
}

